/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.client.model;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import teamdraco.finsandstails.common.entities.PenglilEntity;

public class PenglilModel
extends DefaultedEntityGeoModel<PenglilEntity> {
    public static final Map<Integer, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_1.png"));
        hashMap.put(1, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_2.png"));
        hashMap.put(2, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_3.png"));
        hashMap.put(3, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_4.png"));
        hashMap.put(4, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_5.png"));
        hashMap.put(5, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_6.png"));
        hashMap.put(6, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_7.png"));
        hashMap.put(7, new ResourceLocation("finsandtails", "textures/entity/penglil/penglil_8.png"));
        hashMap.put(8, new ResourceLocation("finsandtails", "textures/entity/penglil/lord_penglil.png"));
        hashMap.put(9, new ResourceLocation("finsandtails", "textures/entity/penglil/pomegranits.png"));
        hashMap.put(10, new ResourceLocation("finsandtails", "textures/entity/penglil/sus_penglil.png"));
    });

    public PenglilModel() {
        super(new ResourceLocation("finsandtails", "penglil"));
    }

    public ResourceLocation getTextureResource(PenglilEntity entity) {
        String s;
        return switch (s = entity.m_7755_().getString()) {
            case "Lord", "Lord Penglil", "Lord_Penglil" -> TEXTURES.get(8);
            case "Pomegranits" -> TEXTURES.get(9);
            case "Sus", "Amogus", "Impostor", "Among Us" -> TEXTURES.get(10);
            default -> TEXTURES.getOrDefault(entity.getVariant(), TEXTURES.get(0));
        };
    }

    public void setCustomAnimations(PenglilEntity entity, long uniqueID, AnimationState<PenglilEntity> customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        CoreGeoBone body = this.getAnimationProcessor().getBone("body");
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        if (entity.m_20069_()) {
            body.setRotX(extraData.headPitch() * ((float)Math.PI / 180) - 70.0f);
            body.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        } else {
            body.setRotX(0.0f);
            body.setRotY(0.0f);
        }
    }
}

