/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import teamdraco.finsandstails.FinsAndTails;
import teamdraco.finsandstails.client.FTItemProperties;
import teamdraco.finsandstails.client.render.BandedRedbackShrimpRenderer;
import teamdraco.finsandstails.client.render.BluWeeRenderer;
import teamdraco.finsandstails.client.render.CrownedHorateeRenderer;
import teamdraco.finsandstails.client.render.FlatbackLeafSnailRenderer;
import teamdraco.finsandstails.client.render.FlatbackSuckerRenderer;
import teamdraco.finsandstails.client.render.GoldenRiverRayRenderer;
import teamdraco.finsandstails.client.render.GopjetRenderer;
import teamdraco.finsandstails.client.render.HighFinnedBlueRenderer;
import teamdraco.finsandstails.client.render.MudhorseRenderer;
import teamdraco.finsandstails.client.render.NightlightSquidRenderer;
import teamdraco.finsandstails.client.render.OrnateBugfishRenderer;
import teamdraco.finsandstails.client.render.PapaWeeRenderer;
import teamdraco.finsandstails.client.render.PeaWeeRenderer;
import teamdraco.finsandstails.client.render.PenglilRenderer;
import teamdraco.finsandstails.client.render.PhantomNudibranchRenderer;
import teamdraco.finsandstails.client.render.RedBullCrabRenderer;
import teamdraco.finsandstails.client.render.RiverPebbleSnailRenderer;
import teamdraco.finsandstails.client.render.RubberBellyGliderRenderer;
import teamdraco.finsandstails.client.render.SiderolWhiskeredSnailRenderer;
import teamdraco.finsandstails.client.render.SpindlyGemCrabRenderer;
import teamdraco.finsandstails.client.render.SwampMuckerRenderer;
import teamdraco.finsandstails.client.render.TealArrowfishArrowRenderer;
import teamdraco.finsandstails.client.render.TealArrowfishRenderer;
import teamdraco.finsandstails.client.render.VibraWeeRenderer;
import teamdraco.finsandstails.client.render.WanderingSailorRenderer;
import teamdraco.finsandstails.client.render.WeeWeeRenderer;
import teamdraco.finsandstails.client.render.WherbleRenderer;
import teamdraco.finsandstails.client.render.WhiteBullCrabRenderer;
import teamdraco.finsandstails.client.screen.CrabCruncherScreen;
import teamdraco.finsandstails.client.screen.MudhorsePouchScreen;
import teamdraco.finsandstails.network.TriggerFlyingPacket;
import teamdraco.finsandstails.registry.FTContainers;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTTags;

@Mod.EventBusSubscriber(modid="finsandtails", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation HEARTS_TEXTURE = new ResourceLocation("finsandtails", "textures/gui/icons.png");
    private static final ResourceLocation GAUNTLET_OVERLAY_TEXTURE = new ResourceLocation("finsandtails", "textures/gui/overlay/gauntlet.png");
    private static final ResourceLocation GAUNTLET_BG_TEXTURE = new ResourceLocation("finsandtails", "textures/gui/overlay/gauntlet_bg.png");

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)FTEntities.BLU_WEE.get(), BluWeeRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.BANDED_REDBACK_SHRIMP.get(), BandedRedbackShrimpRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.PEA_WEE.get(), PeaWeeRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.RED_BULL_CRAB.get(), RedBullCrabRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.WHITE_BULL_CRAB.get(), WhiteBullCrabRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.FLATBACK_LEAF_SNAIL.get(), FlatbackLeafSnailRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.FLATBACK_SUCKER.get(), FlatbackSuckerRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.GOLDEN_RIVER_RAY.get(), GoldenRiverRayRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.GOPJET.get(), GopjetRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.HIGH_FINNED_BLUE.get(), HighFinnedBlueRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.SWAMP_MUCKER.get(), SwampMuckerRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.MUDHORSE.get(), MudhorseRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.WEE_WEE.get(), WeeWeeRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.NIGHT_LIGHT_SQUID.get(), NightlightSquidRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.ORNATE_BUGFISH.get(), OrnateBugfishRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.PAPA_WEE.get(), PapaWeeRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.PENGLIL.get(), PenglilRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.PHANTOM_NUDIBRANCH.get(), PhantomNudibranchRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.RIVER_PEBBLE_SNAIL.get(), RiverPebbleSnailRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.RUBBER_BELLY_GLIDER.get(), RubberBellyGliderRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.SIDEROL_WHISKERED_SNAIL.get(), SiderolWhiskeredSnailRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.TEAL_ARROWFISH_ARROW.get(), TealArrowfishArrowRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.TEAL_ARROWFISH.get(), TealArrowfishRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.VIBRA_WEE.get(), VibraWeeRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.WHERBLE.get(), WherbleRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.WANDERING_SAILOR.get(), WanderingSailorRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.SPINDLY_GEM_CRAB.get(), SpindlyGemCrabRenderer::new);
        event.registerEntityRenderer((EntityType)FTEntities.CROWNED_HORATTE.get(), CrownedHorateeRenderer::new);
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)FTContainers.MUDHORSE_POUCH.get()), MudhorsePouchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FTContainers.CRAB_CRUNCHER.get()), CrabCruncherScreen::new);
        event.enqueueWork(FTItemProperties::setupItemProperties);
    }

    @Mod.EventBusSubscriber(modid="finsandtails", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeBus {
        private static boolean wasJumping;

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft minecraft = Minecraft.m_91087_();
                LocalPlayer player = minecraft.f_91074_;
                if (player != null && (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == FTItems.GOPJET_JETPACK.get() || player.m_6844_(EquipmentSlot.CHEST).m_41720_() == FTItems.ARMORED_GOPJET_JETPACK.get())) {
                    boolean jumping = minecraft.f_91066_.f_92089_.m_90857_();
                    if (jumping != wasJumping) {
                        TriggerFlyingPacket packet = new TriggerFlyingPacket(jumping);
                        packet.handle((Player)player);
                        FinsAndTails.NETWORK.sendToServer((Object)packet);
                    }
                    wasJumping = jumping;
                }
            }
        }

        @SubscribeEvent
        public static void playerGuiRender(RenderGuiOverlayEvent.Post event) {
            boolean hasGauntlets;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!(chest.m_41619_() || event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type() || player.m_7500_() || player.m_5833_())) {
                CharmType charm = CharmType.getCharm((Player)player);
                if (charm == null) {
                    return;
                }
                PoseStack poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                RenderSystem.enableBlend();
                ForgeBus.renderPlayerHealth(event.getGuiGraphics(), (Player)player, charm);
                RenderSystem.disableBlend();
                poseStack.m_85849_();
            }
            InteractionHand offhand = InteractionHand.OFF_HAND;
            InteractionHand mainhand = InteractionHand.MAIN_HAND;
            boolean bl = hasGauntlets = player.m_21120_(mainhand).m_204117_(FTTags.CLAW_GAUNTLETS) && player.m_21120_(offhand).m_204117_(FTTags.CLAW_GAUNTLETS);
            if (hasGauntlets && event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && !player.m_5833_()) {
                PoseStack poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                RenderSystem.enableBlend();
                ForgeBus.renderGauntletOverlay(event.getGuiGraphics());
                RenderSystem.disableBlend();
                poseStack.m_85849_();
            }
        }

        protected static void renderGauntletOverlay(GuiGraphics guiGraphics) {
        }

        private static void renderPlayerHealth(GuiGraphics guiGraphics, Player player, CharmType charm) {
            Gui gui = Minecraft.m_91087_().f_91065_;
            if (player != null) {
                boolean highlight;
                int health = Mth.m_14167_((float)player.m_21223_());
                health = Mth.m_14045_((int)health, (int)0, (int)8);
                boolean bl = highlight = gui.f_92976_ > (long)gui.f_92989_ && (gui.f_92976_ - (long)gui.f_92989_) / 3L % 2L == 1L;
                if (health < gui.f_92973_ && player.f_19802_ > 0) {
                    gui.f_92975_ = Util.m_137550_();
                    gui.f_92976_ = gui.f_92989_ + 20;
                } else if (health > gui.f_92973_ && player.f_19802_ > 0) {
                    gui.f_92975_ = Util.m_137550_();
                    gui.f_92976_ = gui.f_92989_ + 10;
                }
                if (Util.m_137550_() - gui.f_92975_ > 1000L) {
                    gui.f_92974_ = health;
                    gui.f_92975_ = Util.m_137550_();
                }
                gui.f_92973_ = health;
                int healthLast = gui.f_92974_;
                int x = gui.f_92977_ / 2 - 91;
                int y = gui.f_92978_ - 39;
                float healthMax = Math.max((float)player.m_21133_(Attributes.f_22276_), (float)Math.max(healthLast, health));
                int absorption = Mth.m_14167_((float)player.m_6103_());
                int healthRows = Mth.m_14167_((float)(healthMax / 20.0f));
                int rowHeight = Math.max(10 - (healthRows - 2), 3);
                int regen = -1;
                gui.f_92985_.m_188584_((long)(gui.f_92989_ * 312871));
                if (player.m_21023_(MobEffects.f_19605_)) {
                    regen = gui.f_92989_ % Mth.m_14167_((float)(healthMax + 5.0f));
                }
                gui.f_92986_.m_91307_().m_6182_("health");
                ForgeBus.renderHearts(guiGraphics, charm, x, y, rowHeight, regen, healthMax, health, absorption, highlight);
            }
        }

        public static void renderHearts(GuiGraphics stack, CharmType charm, int x, int y, int rowHeight, int regen, float healthMax, int health, int absorption, boolean highlight) {
            Gui gui = Minecraft.m_91087_().f_91065_;
            int heartCount = Mth.m_14165_((double)((double)healthMax / 2.0));
            int absorptionHeartCount = Mth.m_14165_((double)((double)absorption / 2.0));
            for (int heart = heartCount + absorptionHeartCount - 1; heart >= 0; --heart) {
                int level = heart / 10;
                int index = heart % 10;
                int heartX = x + index * 8;
                int heartY = y - level * rowHeight;
                if (health + absorption <= 4) {
                    heartY += gui.f_92985_.m_188503_(2);
                }
                if (heart < heartCount && heart == regen) {
                    heartY -= 2;
                }
                int halfHeartIndex = heart * 2;
                if (highlight && halfHeartIndex < absorption) {
                    ForgeBus.renderHeart(stack, charm, heartX, heartY, true, halfHeartIndex + 1 == absorption);
                }
                if (halfHeartIndex >= health) continue;
                ForgeBus.renderHeart(stack, charm, heartX, heartY, false, halfHeartIndex + 1 == health);
            }
        }

        private static void renderHeart(GuiGraphics pGuiGraphics, CharmType type, int x, int y, boolean highlight, boolean halfHeart) {
            pGuiGraphics.m_280218_(HEARTS_TEXTURE, x, y, type.getX(halfHeart, highlight), 0, 9, 9);
        }

        public static enum CharmType {
            RUBY,
            EMERALD,
            AMBER,
            PEARL,
            SAPPHIRE,
            GEM;


            public int getX(boolean halfHeart, boolean highlight) {
                if (halfHeart) {
                    return this.ordinal() * 18 + 9;
                }
                return this.ordinal() * 18;
            }

            static CharmType getCharm(Player player) {
                ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
                if (stack.m_150930_((Item)FTItems.SPINDLY_RUBY_CHARM.get())) {
                    return RUBY;
                }
                if (stack.m_150930_((Item)FTItems.SPINDLY_EMERALD_CHARM.get())) {
                    return EMERALD;
                }
                if (stack.m_150930_((Item)FTItems.SPINDLY_AMBER_CHARM.get())) {
                    return AMBER;
                }
                if (stack.m_150930_((Item)FTItems.SPINDLY_PEARL_CHARM.get())) {
                    return PEARL;
                }
                if (stack.m_150930_((Item)FTItems.SPINDLY_SAPPHIRE_CHARM.get())) {
                    return SAPPHIRE;
                }
                if (stack.m_150930_((Item)FTItems.GEM_CRAB_AMULET.get())) {
                    return GEM;
                }
                return null;
            }
        }
    }
}

