/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.entity.WeaselEntity;
import com.pepper.faunify.entity.client.model.WeaselModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WeaselRenderer
extends GeoEntityRenderer<WeaselEntity> {
    private static final ResourceLocation STOAT = new ResourceLocation("faunify", "textures/entity/weasel1.png");
    private static final ResourceLocation STEPPE = new ResourceLocation("faunify", "textures/entity/weasel2.png");
    private static final ResourceLocation EUROPEAN = new ResourceLocation("faunify", "textures/entity/weasel3.png");
    private static final ResourceLocation SIBERIAN = new ResourceLocation("faunify", "textures/entity/weasel4.png");
    private static final ResourceLocation YELLOWBELLIED = new ResourceLocation("faunify", "textures/entity/weasel5.png");
    private static final ResourceLocation FERRETDARK = new ResourceLocation("faunify", "textures/entity/ferret1.png");
    private static final ResourceLocation FERRETLIGHT = new ResourceLocation("faunify", "textures/entity/ferret2.png");

    public WeaselRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new WeaselModel());
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(WeaselEntity entity) {
        if (entity.isSnowVariant()) {
            return new ResourceLocation("faunify", "textures/entity/weasel_snowy.png");
        }
        return WeaselRenderer.getVariantTexture(entity.getVariant());
    }

    public static ResourceLocation getVariantTexture(WeaselEntity.Variant variant) {
        return switch (variant) {
            case WeaselEntity.Variant.STOAT -> STOAT;
            case WeaselEntity.Variant.STEPPE -> STEPPE;
            case WeaselEntity.Variant.EUROPEAN -> EUROPEAN;
            case WeaselEntity.Variant.SIBERIAN -> SIBERIAN;
            case WeaselEntity.Variant.YELLOWBELLIED -> YELLOWBELLIED;
            case WeaselEntity.Variant.FERRETDARK -> FERRETDARK;
            case WeaselEntity.Variant.FERRETLIGHT -> FERRETLIGHT;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public void preRender(PoseStack stack, WeaselEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.65f;
            stack.m_85841_(babyScale, babyScale, babyScale);
            float headScale = 1.5f;
            stack.m_85836_();
            model.getBone("head").ifPresent(head -> {
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            });
            stack.m_85849_();
        } else {
            float adultScale = 0.95f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

