/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.entity.FennecEntity;
import com.pepper.faunify.entity.client.model.FennecModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FennecRenderer
extends GeoEntityRenderer<FennecEntity> {
    private static final ResourceLocation LIGHT = new ResourceLocation("faunify", "textures/entity/fennec1.png");
    private static final ResourceLocation DARK = new ResourceLocation("faunify", "textures/entity/fennec2.png");

    public FennecRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FennecModel());
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(FennecEntity entity) {
        return FennecRenderer.getVariantTexture(entity.getVariant());
    }

    public static ResourceLocation getVariantTexture(FennecEntity.Variant variant) {
        return switch (variant) {
            case FennecEntity.Variant.LIGHT -> LIGHT;
            case FennecEntity.Variant.DARK -> DARK;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public void preRender(PoseStack stack, FennecEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.65f;
            stack.m_85841_(babyScale, babyScale, babyScale);
            float headScale = 1.3f;
            stack.m_85836_();
            model.getBone("head").ifPresent(head -> {
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            });
            stack.m_85849_();
        } else {
            float adultScale = 0.9f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

