/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.misc;

import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundUpdateRecipesMessage {
    private final List<BlockConversionRecipe<?>> blockRecipes;
    private final List<EntityConversionRecipe<?>> entityRecipes;

    public ClientboundUpdateRecipesMessage(List<BlockConversionRecipe<?>> blockRecipes, List<EntityConversionRecipe<?>> entityRecipes) {
        this.blockRecipes = blockRecipes;
        this.entityRecipes = entityRecipes;
    }

    public static void encode(ClientboundUpdateRecipesMessage msg, FriendlyByteBuf buffer) {
        buffer.m_236828_(msg.blockRecipes, (b, recipe) -> recipe.writeToBuffer((FriendlyByteBuf)b));
        buffer.m_236828_(msg.entityRecipes, (b, recipe) -> recipe.writeToBuffer((FriendlyByteBuf)b));
    }

    public static ClientboundUpdateRecipesMessage decode(FriendlyByteBuf buffer) {
        ArrayList blockRecipes = new ArrayList(buffer.m_236838_(ArrayList::new, BlockConversionRecipe::readFromBuffer));
        ArrayList entityRecipes = new ArrayList(buffer.m_236838_(ArrayList::new, EntityConversionRecipe::readFromBuffer));
        return new ClientboundUpdateRecipesMessage(blockRecipes, entityRecipes);
    }

    public static void handle(ClientboundUpdateRecipesMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ConversionRecipeManager.INSTANCE.replaceAllRecipes(msg.blockRecipes, msg.entityRecipes));
    }
}

