/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory.handler;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.inventory.handler.ToggleableSlot;
import java.util.function.IntUnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class AbstractHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final ResourceLocation forcedScreenType;

    public AbstractHandler(int syncId, Container inventory, Inventory playerInventory, ResourceLocation forcedScreenType) {
        super(CommonMain.platformHelper().getScreenHandlerType(), syncId);
        this.inventory = inventory;
        this.forcedScreenType = forcedScreenType;
        inventory.m_5856_(playerInventory.f_35978_);
        if (playerInventory.f_35978_ instanceof ServerPlayer) {
            int i;
            for (i = 0; i < inventory.m_6643_(); ++i) {
                this.m_38897_(new Slot(inventory, i, i * 18, 0));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, 18 * x, y * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.m_38897_(new Slot((Container)playerInventory, i, i * 18, 36));
            }
        }
    }

    public static AbstractHandler createClientMenu(int syncId, Inventory playerInventory, FriendlyByteBuf buffer) {
        int inventorySize = buffer.readInt();
        ResourceLocation forcedScreenType = null;
        if (buffer.readableBytes() > 0) {
            forcedScreenType = buffer.m_130281_();
        }
        return new AbstractHandler(syncId, (Container)new SimpleContainer(inventorySize), playerInventory, forcedScreenType);
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack newStack = slot.m_7993_();
            originalStack = newStack.m_41777_();
            if (index < this.inventory.m_6643_() ? !this.m_38903_(newStack, this.inventory.m_6643_(), this.inventory.m_6643_() + 36, true) : !this.m_38903_(newStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (newStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return originalStack;
    }

    public void resetSlotPositions(boolean createSlots, int menuWidth, int menuHeight) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            int realYPos;
            int slotXPos = i % menuWidth;
            int slotYPos = Mth.m_14165_((double)((double)(i - slotXPos) / (double)menuWidth));
            int n = realYPos = slotYPos >= menuHeight ? 18 * (slotYPos % menuHeight) - 2000 : slotYPos * 18;
            if (createSlots) {
                this.m_38897_(new ToggleableSlot(this.inventory, i, slotXPos * 18 + 8, realYPos + 18, slotYPos < menuHeight));
                continue;
            }
            ((Slot)this.f_38839_.get((int)i)).f_40221_ = realYPos + 18;
        }
    }

    public void moveSlotRange(int minSlotIndex, int maxSlotIndex, int yDifference) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.f_38839_.get(i));
            slot.f_40221_ += yDifference;
            if (yDifference != -2000 && yDifference != 2000) continue;
            slot.toggleActive();
        }
    }

    public void setSlotRange(int minSlotIndex, int maxSlotIndex, IntUnaryOperator yMutator) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.f_38839_.get(i));
            int newY = yMutator.applyAsInt(i);
            if (newY - slot.f_40221_ > 1000 || slot.f_40221_ - newY > 1000) {
                ((ToggleableSlot)((Object)this.f_38839_.get(i))).toggleActive();
            }
            slot.f_40221_ = newY;
        }
    }

    public void clearSlots() {
        this.f_38839_.clear();
        this.f_150394_.clear();
        this.f_38841_.clear();
    }

    public void addClientSlot(Slot slot) {
        this.m_38897_(slot);
    }

    public ResourceLocation getForcedScreenType() {
        return this.forcedScreenType;
    }
}

