/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.handler.InventorySlotFunction;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class VariableInventory
implements Container {
    private final Container[] parts;
    private final int size;
    private final int maxStackCount;

    private VariableInventory(Container ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            Objects.requireNonNull(parts[i], "part at index" + i + " must not be null");
        }
        this.parts = parts;
        this.size = Arrays.stream(parts).mapToInt(Container::m_6643_).sum();
        this.maxStackCount = parts[0].m_6893_();
        for (Container part : parts) {
            assert (part.m_6893_() == this.maxStackCount) : "all parts must have equal max stack counts.";
        }
    }

    public static Container of(Container ... parts) {
        assert (parts.length > 0) : "parts must contain at least 1 inventory";
        if (parts.length == 1) {
            return parts[0];
        }
        return new VariableInventory(parts);
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        for (Container part : this.parts) {
            if (part.m_7983_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, Container::m_8020_);
    }

    private void validateSlotIndex(int slot) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7407_(rSlot, amount));
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, Container::m_8016_);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        this.consumeSlot(slot, (part, rSlot) -> part.m_6836_(rSlot, stack));
    }

    public int m_6893_() {
        return this.maxStackCount;
    }

    public void m_6596_() {
        for (Container part : this.parts) {
            part.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        for (Container part : this.parts) {
            if (part.m_6542_(player)) continue;
            return false;
        }
        return true;
    }

    public void m_5856_(Player player) {
        for (Container part : this.parts) {
            part.m_5856_(player);
        }
    }

    public void m_5785_(Player player) {
        for (Container part : this.parts) {
            part.m_5785_(player);
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7013_(rSlot, stack));
    }

    public int m_18947_(Item item) {
        int count = 0;
        for (Container part : this.parts) {
            count += part.m_18947_(item);
        }
        return count;
    }

    public boolean m_18949_(Set<Item> set) {
        for (Container part : this.parts) {
            if (!part.m_18949_(set)) continue;
            return true;
        }
        return false;
    }

    public void m_6211_() {
        for (Container part : this.parts) {
            part.m_6211_();
        }
    }

    private void consumeSlot(int slot, ObjIntConsumer<Container> consumer) {
        for (Container part : this.parts) {
            int inventorySize = part.m_6643_();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            consumer.accept(part, slot);
            return;
        }
        throw new IllegalStateException("consumeSlot called without validating slot bounds.");
    }

    private <T> T applyFunctionToSlot(int slot, InventorySlotFunction<Container, T> function) {
        for (Container part : this.parts) {
            int inventorySize = part.m_6643_();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            return function.apply(part, slot);
        }
        throw new IllegalStateException("applyFunctionToSlot called without validating slot bounds.");
    }

    public boolean containsPart(Container part) {
        for (Container inventory : this.parts) {
            if (inventory != part) continue;
            return true;
        }
        return false;
    }
}

