/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.fixer;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import compasses.expandedstorage.impl.fixer.ES1_17_1Schema2707v1;
import compasses.expandedstorage.impl.fixer.ES1_18_0Schema2851v1;
import java.util.Map;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.StatsRenameFix;

public class DataFixerUtils {
    public static void register1_17DataFixer(DataFixerBuilder builder, int version, int subVersion) {
        Schema es1_17_1Schema = builder.addSchema(version, subVersion, ES1_17_1Schema2707v1::new);
        builder.addFixer((DataFix)new AddNewChoices(es1_17_1Schema, "Add Expanded Storage BE", References.f_16781_));
    }

    public static void register1_18DataFixer(DataFixerBuilder builder, int version, int subVersion) {
        Schema es1_18_0Schema = builder.addSchema(version, subVersion, ES1_18_0Schema2851v1::new);
        builder.addFixer((DataFix)new AddNewChoices(es1_18_0Schema, "Add renamed Expanded Storage BE", References.f_16781_));
        builder.addFixer(BlockRenameFix.m_14914_((Schema)es1_18_0Schema, (String)"Rename ES Blocks: christmas_chest -> present", id -> {
            if (id.equals("expandedstorage:christmas_chest")) {
                return "expandedstorage:present";
            }
            return id;
        }));
        builder.addFixer(ItemRenameFix.m_16003_((Schema)es1_18_0Schema, (String)"Rename ES Items: christmas_chest -> present, chest_mutator -> storage_mutator", id -> {
            if (id.equals("expandedstorage:christmas_chest")) {
                return "expandedstorage:present";
            }
            if (id.equals("expandedstorage:chest_mutator")) {
                return "expandedstorage:storage_mutator";
            }
            return id;
        }));
        builder.addFixer((DataFix)new StatsRenameFix(es1_18_0Schema, "Rename ES Stats: open_christmas_chest -> open_present", Map.of("expandedstorage:open_christmas_chest", "expandedstorage:open_present")));
    }
}

