/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.TexturedRect;
import compasses.expandedstorage.impl.client.gui.widget.PageButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;

@IPNGuiHint(button=IPNButton.MOVE_TO_CONTAINER, horizontalOffset=58)
public final class PageScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new LinkedHashSet<TexturedRect>();
    private final int blankSlots;
    private final int pages;
    private PageButton leftPageButton;
    private PageButton rightPageButton;
    private int page = 1;
    private MutableComponent currentPageText;
    private float pageTextX;

    public PageScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        this.pages = Mth.m_14165_((double)((double)this.totalSlots / (double)slotsPerPage));
        int lastPageSlots = this.totalSlots - (this.pages - 1) * slotsPerPage;
        this.blankSlots = slotsPerPage - lastPageSlots;
        this.f_97726_ = 7 + 18 * this.inventoryWidth + 7;
        this.f_97727_ = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.recalculateBlankArea();
    }

    private static boolean regionIntersects(AbstractWidget widget, int x, int y, int width, int height) {
        return widget.m_252754_() <= x + width && y <= widget.m_252907_() + widget.m_93694_() || x <= widget.m_252754_() + widget.m_5711_() && widget.m_252907_() <= y + height;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        if (CommonClient.platformHelper().configWrapper().fitVanillaConstraints()) {
            return new ScreenSize(9, 6);
        }
        ArrayList<Pair<ScreenSize, ScreenSize>> options = new ArrayList<Pair<ScreenSize, ScreenSize>>();
        PageScreen.addEntry(options, slots, 9, 3);
        PageScreen.addEntry(options, slots, 9, 6);
        if (scaledHeight >= 276 && slots > 54) {
            PageScreen.addEntry(options, slots, 9, 9);
        }
        if (slots > 90) {
            PageScreen.addEntry(options, slots, 15, 6);
        }
        Pair<ScreenSize, ScreenSize> picked = options.get(0);
        for (int i = 1; i < options.size(); ++i) {
            Pair<ScreenSize, ScreenSize> option = options.get(i);
            int currentPages = ((ScreenSize)picked.getSecond()).width();
            int currentBlankSlots = ((ScreenSize)picked.getSecond()).height();
            int currentWidth = ((ScreenSize)picked.getFirst()).width();
            int newPages = ((ScreenSize)option.getSecond()).width();
            int newBlankSlots = ((ScreenSize)option.getSecond()).height();
            int newWidth = ((ScreenSize)option.getFirst()).width();
            int newHeight = ((ScreenSize)option.getFirst()).height();
            if (newBlankSlots <= currentBlankSlots && newPages < currentPages && currentWidth == newWidth) {
                picked = option;
                continue;
            }
            if (CommonClient.platformHelper().configWrapper().preferSmallerScreens() && currentPages == newPages + 1 && (double)newBlankSlots < (double)(newWidth * newHeight) / 2.0 || newPages >= currentPages || !((double)newBlankSlots < (double)(newWidth * newHeight) / 2.0)) continue;
            picked = option;
        }
        return (ScreenSize)picked.getFirst();
    }

    private static void addEntry(ArrayList<Pair<ScreenSize, ScreenSize>> options, int slots, int width, int height) {
        int pages = Mth.m_14165_((double)((double)slots / (double)(width * height)));
        int blanked = slots - pages * width * height;
        options.add((Pair<ScreenSize, ScreenSize>)new Pair((Object)new ScreenSize(width, height), (Object)new ScreenSize(pages, blanked)));
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(this.textureLocation, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.textureWidth, this.textureHeight);
        if (this.page == this.pages) {
            this.blankArea.forEach(image -> image.render(graphics));
        }
    }

    private void initializeSlots(Inventory playerInventory) {
        ((AbstractHandler)this.f_97732_).resetSlotPositions(true, this.inventoryWidth, this.inventoryHeight);
        int playerInvLeft = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int playerInvTop = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, playerInvLeft + 18 * x, playerInvTop + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, playerInvLeft + 18 * x, playerInvTop + 58));
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.f_97726_ - 176) / 2)) || mouseX > (double)(left + this.f_97726_ - outsideRegion))) {
            return true;
        }
        return super.m_7467_(mouseX, mouseY, left, top, button);
    }

    private void setPage(int oldPage, int newPage) {
        if (newPage == 0 || newPage > this.pages) {
            return;
        }
        this.page = newPage;
        if (newPage > oldPage) {
            if (this.page == this.pages) {
                this.rightPageButton.setActive(false);
            }
            if (!this.leftPageButton.f_93623_) {
                this.leftPageButton.setActive(true);
            }
        } else if (newPage < oldPage) {
            if (this.page == 1) {
                this.leftPageButton.setActive(false);
            }
            if (!this.rightPageButton.f_93623_) {
                this.rightPageButton.setActive(true);
            }
        }
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        int oldMin = slotsPerPage * (oldPage - 1);
        int oldMax = Math.min(oldMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.f_97732_).moveSlotRange(oldMin, oldMax, -2000);
        int newMin = slotsPerPage * (newPage - 1);
        int newMax = Math.min(newMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.f_97732_).moveSlotRange(newMin, newMax, 2000);
        this.setPageText();
    }

    private void setPageText() {
        this.currentPageText = Component.m_237110_((String)"screen.expandedstorage.page_x_y", (Object[])new Object[]{this.page, this.pages});
        this.pageTextX = (float)(this.leftPageButton.m_252754_() + this.leftPageButton.m_5711_() + this.rightPageButton.m_252754_()) / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.currentPageText) / 2.0f + 0.5f;
    }

    private void recalculateBlankArea() {
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = Math.floorDiv(this.blankSlots, this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.f_97736_ + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.f_97735_ + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(this.textureLocation, xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.f_97735_ + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(this.textureLocation, xRight - width, yTop, width, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (this.currentPageText != null) {
            graphics.m_280649_(this.f_96547_, this.currentPageText.m_7532_(), (int)(this.pageTextX - (float)this.f_97735_), this.f_97727_ - 94, 0x404040, false);
        }
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262 || keyCode == 267) {
            this.setPage(this.page, PageScreen.m_96638_() ? this.pages : this.page + 1);
            return true;
        }
        if (keyCode == 263 || keyCode == 266) {
            this.setPage(this.page, PageScreen.m_96638_() ? 1 : this.page - 1);
            return true;
        }
        return false;
    }

    public void addPageButtons() {
        int x;
        int width = 54;
        int originalX = x = this.f_97735_ + this.f_97726_ - 61;
        int y = this.f_97736_ + this.f_97727_ - 96;
        ArrayList<AbstractWidget> renderableChildren = new ArrayList<AbstractWidget>();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)child;
            renderableChildren.add(widget);
        }
        renderableChildren.sort(Comparator.comparingInt(a -> -a.m_252754_()));
        for (AbstractWidget widget : renderableChildren) {
            if (!PageScreen.regionIntersects(widget, x, y, width, 12)) continue;
            x = widget.m_252754_() - width - 2;
        }
        if (x == originalX && CommonClient.platformHelper().isModLoaded("inventoryprofiles")) {
            x -= 14;
        }
        this.leftPageButton = new PageButton(x, y, 0, (Component)Component.m_237115_((String)"screen.expandedstorage.prev_page"), button -> this.setPage(this.page, this.page - 1));
        this.leftPageButton.f_93623_ = this.page != 1;
        this.m_142416_((GuiEventListener)this.leftPageButton);
        this.rightPageButton = new PageButton(x + 42, y, 1, (Component)Component.m_237115_((String)"screen.expandedstorage.next_page"), button -> this.setPage(this.page, this.page + 1));
        this.rightPageButton.f_93623_ = this.page != this.pages;
        this.m_142416_((GuiEventListener)this.rightPageButton);
        this.setPageText();
    }
}

