/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.PickScreen;
import compasses.expandedstorage.impl.client.gui.widget.PickButton;
import compasses.expandedstorage.impl.client.gui.widget.ScreenPickButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class FakePickScreen
extends AbstractScreen {
    private static final Component TITLE = Component.m_237115_((String)"screen.expandedstorage.screen_picker_title");
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(PickScreen.BUTTON_SETTINGS.keySet());
    private int topPadding;

    public FakePickScreen(AbstractHandler handler, Inventory playerInventory, Component title) {
        super(handler, playerInventory, title, new ScreenSize(0, 0));
        for (int i = 0; i < ((AbstractHandler)this.f_97732_).getInventory().m_6643_(); ++i) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot(((AbstractHandler)this.f_97732_).getInventory(), i, 0, 0));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, 0, 0));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, 0, 0));
        }
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
    }

    public void m_7379_() {
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        if (preference == null) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            int invSize = ((AbstractHandler)this.f_97732_).getInventory().m_6643_();
            if (FakePickScreen.getScreenSize(preference, invSize, this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_()) == null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"text.expandedstorage.short_prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"chat.expandedstorage.cannot_display_screen", (Object[])new Object[]{Component.m_237115_((String)("screen." + preference.m_135827_() + "." + preference.m_135815_() + "_screen"))}).m_130940_(ChatFormatting.WHITE)), false);
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            ((AbstractHandler)this.f_97732_).clearSlots();
            this.f_96541_.m_91152_((Screen)FakePickScreen.createScreen((AbstractHandler)this.f_97732_, Minecraft.m_91087_().f_91074_.m_150109_(), this.m_96636_()));
        }
    }

    protected void m_7856_() {
        int topPadding;
        super.m_7856_();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.f_96543_, 96), choices);
        int innerPadding = Math.min((this.f_96543_ - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.f_96543_ - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.f_96544_ - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = PickScreen.BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.shouldShowWarning(this.f_96543_, this.f_96544_);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.m_237113_((String)"").m_7220_(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.m_130946_("\n");
                tooltipMessage.m_7220_(PickScreen.CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.m_130946_("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).m_7220_(arg_0));
            }
            this.m_142416_((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.m_257550_((Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.m_7379_();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(graphics, mouseX, mouseY, delta);
        }
        graphics.m_280653_(this.f_96547_, TITLE, this.f_96543_ / 2, Math.max(this.topPadding / 2, 0), -1);
    }
}

