/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.misc;

import compasses.expandedstorage.impl.block.misc.DoublePropertyRetriever;
import compasses.expandedstorage.impl.block.misc.EmptyPropertyRetriever;
import compasses.expandedstorage.impl.block.misc.Property;
import compasses.expandedstorage.impl.block.misc.SinglePropertyRetriever;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface PropertyRetriever<A> {
    public static <A extends BlockEntity> PropertyRetriever<A> create(BlockEntityType<A> blockEntityType, Function<BlockState, DoubleBlockCombiner.BlockType> typeGetter, BiFunction<BlockState, Direction, Direction> attachedDirectionGetter, Function<BlockState, Direction> directionGetter, BlockState state, LevelAccessor level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> blockInaccessible) {
        Direction facing;
        BlockPos attachedPos;
        BlockState attachedState;
        BlockEntity entity = blockEntityType.m_58949_((BlockGetter)level, pos);
        if (entity == null || blockInaccessible.test(level, pos)) {
            return new EmptyPropertyRetriever();
        }
        DoubleBlockCombiner.BlockType type = typeGetter.apply(state);
        if (type != DoubleBlockCombiner.BlockType.SINGLE && (attachedState = level.m_8055_(attachedPos = pos.m_121945_(attachedDirectionGetter.apply(state, facing = directionGetter.apply(state))))).m_60713_(state.m_60734_()) && PropertyRetriever.areTypesOpposite(type, typeGetter.apply(attachedState)) && facing == directionGetter.apply(attachedState)) {
            if (blockInaccessible.test(level, attachedPos)) {
                return new EmptyPropertyRetriever();
            }
            BlockEntity attachedEntity = blockEntityType.m_58949_((BlockGetter)level, attachedPos);
            if (attachedEntity != null) {
                if (type == DoubleBlockCombiner.BlockType.FIRST) {
                    return new DoublePropertyRetriever<BlockEntity>(entity, attachedEntity);
                }
                return new DoublePropertyRetriever<BlockEntity>(attachedEntity, entity);
            }
        }
        return new SinglePropertyRetriever<BlockEntity>(entity);
    }

    public static boolean areTypesOpposite(DoubleBlockCombiner.BlockType type, DoubleBlockCombiner.BlockType otherType) {
        return type == DoubleBlockCombiner.BlockType.FIRST && otherType == DoubleBlockCombiner.BlockType.SECOND || type == DoubleBlockCombiner.BlockType.SECOND && otherType == DoubleBlockCombiner.BlockType.FIRST;
    }

    public static <A> PropertyRetriever<A> createDirect(A single) {
        return new SinglePropertyRetriever<A>(single);
    }

    public <B> Optional<B> get(Property<A, B> var1);
}

