/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.entity.extendable;

import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenableBlockEntity
extends BlockEntity
implements OpenableInventory,
Nameable {
    private final ResourceLocation blockId;
    private final Component defaultName;
    private ItemAccess itemAccess;
    private Lockable lockable;
    private Component customName;

    public OpenableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ResourceLocation blockId, Component defaultName) {
        super(type, pos, state);
        this.blockId = blockId;
        this.defaultName = defaultName;
    }

    @Override
    public boolean canBeUsedBy(ServerPlayer player) {
        return this.isValidAndPlayerInRange((Player)player) && this.getLockable().canPlayerOpenLock(player);
    }

    protected final boolean isValidAndPlayerInRange(Player player) {
        return this.m_58904_().m_7702_(this.m_58899_()) == this && player.m_20238_(Vec3.m_82512_((Vec3i)this.m_58899_())) <= 64.0;
    }

    @Override
    public Component getInventoryTitle() {
        return this.m_7755_();
    }

    public abstract NonNullList<ItemStack> getItems();

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lockable.readLock(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.lockable.writeLock(tag);
        if (this.m_8077_()) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public final ResourceLocation getBlockId() {
        return this.blockId;
    }

    public ItemAccess getItemAccess() {
        return this.itemAccess;
    }

    protected void setItemAccess(ItemAccess itemAccess) {
        if (this.itemAccess == null) {
            this.itemAccess = itemAccess;
        }
    }

    public Lockable getLockable() {
        return this.lockable;
    }

    protected void setLockable(Lockable lockable) {
        if (this.lockable == null) {
            this.lockable = lockable;
        }
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public final void setCustomName(Component name) {
        this.customName = name;
    }

    @NotNull
    public final Component m_7755_() {
        return this.m_8077_() ? this.customName : this.defaultName;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.customName != null) {
            updateTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return updateTag;
    }

    public boolean isDinnerbone() {
        return this.m_8077_() && this.customName.getString().equals("Dinnerbone");
    }
}

