/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.misc.Property;
import compasses.expandedstorage.impl.block.misc.PropertyRetriever;
import compasses.expandedstorage.impl.inventory.OpenableInventories;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.context.BlockContext;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractChestBlock
extends OpenableBlock
implements WorldlyContainerHolder {
    public static final EnumProperty<EsChestType> CURSED_CHEST_TYPE = EnumProperty.m_61587_((String)"type", EsChestType.class);
    private static final Property<OldChestBlockEntity, WorldlyContainer> INVENTORY_GETTER = new Property<OldChestBlockEntity, WorldlyContainer>(){

        @Override
        public WorldlyContainer get(OldChestBlockEntity first, OldChestBlockEntity second) {
            WorldlyContainer cachedInventory = first.getCachedDoubleInventory();
            if (cachedInventory == null) {
                first.setCachedDoubleInventory(second);
                return first.getCachedDoubleInventory();
            }
            return cachedInventory;
        }

        @Override
        public WorldlyContainer get(OldChestBlockEntity single) {
            return single.getInventory();
        }
    };

    public AbstractChestBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings, openingStat, slotCount);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE))).m_61124_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    public static <T extends OldChestBlockEntity> PropertyRetriever<T> createPropertyRetriever(AbstractChestBlock block, BlockState state, LevelAccessor level, BlockPos pos, boolean retrieveBlockedChests) {
        BiPredicate<LevelAccessor, BlockPos> isChestBlocked = retrieveBlockedChests ? (_world, _pos) -> false : block::isAccessBlocked;
        return PropertyRetriever.create(block.getBlockEntityType(), s -> AbstractChestBlock.getBlockType((EsChestType)((Object)((Object)s.m_61143_(CURSED_CHEST_TYPE)))), (s, facing) -> AbstractChestBlock.getDirectionToAttached((EsChestType)((Object)((Object)s.m_61143_(CURSED_CHEST_TYPE))), facing), s -> (Direction)s.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_), state, level, pos, isChestBlocked);
    }

    public static Direction getDirectionToAttached(EsChestType type, Direction facing) {
        if (type == EsChestType.TOP) {
            return Direction.DOWN;
        }
        if (type == EsChestType.BACK) {
            return facing;
        }
        if (type == EsChestType.RIGHT) {
            return facing.m_122427_();
        }
        if (type == EsChestType.BOTTOM) {
            return Direction.UP;
        }
        if (type == EsChestType.FRONT) {
            return facing.m_122424_();
        }
        if (type == EsChestType.LEFT) {
            return facing.m_122428_();
        }
        if (type == EsChestType.SINGLE) {
            throw new IllegalArgumentException("AbstractChestBlock#getDirectionToAttached received an unexpected chest type.");
        }
        throw new IllegalArgumentException("AbstractChestBlock#getDirectionToAttached received an unknown chest type.");
    }

    public static Direction getDirectionToAttached(BlockState state) {
        return AbstractChestBlock.getDirectionToAttached((EsChestType)((Object)state.m_61143_(CURSED_CHEST_TYPE)), (Direction)state.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(EsChestType type) {
        if (type == EsChestType.TOP || type == EsChestType.LEFT || type == EsChestType.FRONT) {
            return DoubleBlockCombiner.BlockType.FIRST;
        }
        if (type == EsChestType.BACK || type == EsChestType.RIGHT || type == EsChestType.BOTTOM) {
            return DoubleBlockCombiner.BlockType.SECOND;
        }
        if (type == EsChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        throw new IllegalArgumentException("Invalid EsChestType passed.");
    }

    public static EsChestType getChestType(Direction facing, Direction offset) {
        if (facing.m_122427_() == offset) {
            return EsChestType.RIGHT;
        }
        if (facing.m_122428_() == offset) {
            return EsChestType.LEFT;
        }
        if (facing == offset) {
            return EsChestType.BACK;
        }
        if (facing == offset.m_122424_()) {
            return EsChestType.FRONT;
        }
        if (offset == Direction.DOWN) {
            return EsChestType.TOP;
        }
        if (offset == Direction.UP) {
            return EsChestType.BOTTOM;
        }
        return EsChestType.SINGLE;
    }

    public boolean isAccessBlocked(LevelAccessor level, BlockPos pos) {
        return false;
    }

    protected <T extends OldChestBlockEntity> BlockEntityType<T> getBlockEntityType() {
        return CommonMain.getOldChestBlockEntityType();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new net.minecraft.world.level.block.state.properties.Property[]{CURSED_CHEST_TYPE});
        builder.m_61104_(new net.minecraft.world.level.block.state.properties.Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.getBlockEntityType().m_155264_(pos, state);
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction chestForwardDir;
        EsChestType chestType;
        block2: {
            BlockPos pos;
            Level level;
            block1: {
                level = context.m_43725_();
                pos = context.m_8083_();
                chestType = EsChestType.SINGLE;
                chestForwardDir = context.m_8125_().m_122424_();
                Direction clickedFace = context.m_43719_();
                if (!context.m_7078_()) break block1;
                Direction offsetDir = clickedFace.m_122424_();
                BlockState offsetState = level.m_8055_(pos.m_121945_(offsetDir));
                if (!offsetState.m_60713_((Block)this) || offsetState.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_) != chestForwardDir || offsetState.m_61143_(CURSED_CHEST_TYPE) != EsChestType.SINGLE || !this.areChestsCompatible(level, context.m_43722_(), pos, pos.m_121945_(offsetDir))) break block2;
                chestType = AbstractChestBlock.getChestType(chestForwardDir, offsetDir);
                break block2;
            }
            for (Direction dir : Direction.values()) {
                EsChestType type;
                BlockState offsetState = level.m_8055_(pos.m_121945_(dir));
                if (!offsetState.m_60713_((Block)this) || offsetState.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_) != chestForwardDir || offsetState.m_61143_(CURSED_CHEST_TYPE) != EsChestType.SINGLE || (type = AbstractChestBlock.getChestType(chestForwardDir, dir)) == EsChestType.SINGLE || !this.areChestsCompatible(level, context.m_43722_(), pos, pos.m_121945_(dir))) continue;
                chestType = type;
                break;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_, (Comparable)chestForwardDir)).m_61124_(CURSED_CHEST_TYPE, (Comparable)((Object)chestType));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction offset, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (offsetState.m_60713_((Block)this)) {
            EsChestType offsetType = (EsChestType)((Object)offsetState.m_61143_(CURSED_CHEST_TYPE));
            if (state.m_61143_(CURSED_CHEST_TYPE) == EsChestType.SINGLE && offsetType != EsChestType.SINGLE && state.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_) == offsetState.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_) && AbstractChestBlock.getDirectionToAttached(offsetState) == offset.m_122424_()) {
                return (BlockState)state.m_61124_(CURSED_CHEST_TYPE, (Comparable)((Object)offsetType.getOpposite()));
            }
        } else if (state.m_61143_(CURSED_CHEST_TYPE) != EsChestType.SINGLE && AbstractChestBlock.getDirectionToAttached(state) == offset) {
            return (BlockState)state.m_61124_(CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE));
        }
        return super.m_7417_(state, offset, offsetState, level, pos, offsetPos);
    }

    @Nullable
    public WorldlyContainer m_5840_(BlockState state, LevelAccessor level, BlockPos pos) {
        return AbstractChestBlock.createPropertyRetriever(this, state, level, pos, true).get(INVENTORY_GETTER).orElse(null);
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        EsChestType chestType = (EsChestType)((Object)state.m_61143_(CURSED_CHEST_TYPE));
        if (chestType == EsChestType.SINGLE || chestType == EsChestType.BOTTOM || chestType == EsChestType.TOP) {
            return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_)));
        }
        return super.m_6943_(state, mirror);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        EsChestType chestType = (EsChestType)((Object)state.m_61143_(CURSED_CHEST_TYPE));
        if (chestType == EsChestType.SINGLE || chestType == EsChestType.BOTTOM || chestType == EsChestType.TOP) {
            return (BlockState)state.m_61124_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_)));
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return (BlockState)state.m_61124_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.f_61374_)).m_122424_());
        }
        return super.m_6843_(state, rotation);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        WorldlyContainer inventory = this.m_5840_(state, (LevelAccessor)level, pos);
        if (inventory != null) {
            return AbstractContainerMenu.m_38938_((Container)inventory);
        }
        return super.m_6782_(state, level, pos);
    }

    @Override
    public OpenableInventory getOpenableInventory(BlockContext context) {
        ServerLevel level = context.getLevel();
        BlockPos pos = context.getBlockPos();
        BlockState state = level.m_8055_(pos);
        return AbstractChestBlock.createPropertyRetriever(this, state, (LevelAccessor)level, pos, false).get(new Property<OldChestBlockEntity, OpenableInventory>(){

            @Override
            public OpenableInventory get(OldChestBlockEntity first, OldChestBlockEntity second) {
                Component name = first.m_8077_() ? first.m_7755_() : (second.m_8077_() ? second.m_7755_() : Component.m_237110_((String)"container.expandedstorage.generic_double", (Object[])new Object[]{first.m_7755_()}));
                return OpenableInventories.of(name, first, second);
            }

            @Override
            public OpenableInventory get(OldChestBlockEntity single) {
                return single;
            }
        }).orElse(null);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (state.m_61138_(CURSED_CHEST_TYPE) && newState.m_61138_(CURSED_CHEST_TYPE)) {
            EsChestType oldChestType = (EsChestType)((Object)state.m_61143_(CURSED_CHEST_TYPE));
            EsChestType newChestType = (EsChestType)((Object)newState.m_61143_(CURSED_CHEST_TYPE));
            if (oldChestType != EsChestType.SINGLE && newChestType == EsChestType.SINGLE) {
                BlockEntity blockEntity;
                if (AbstractChestBlock.getBlockType(oldChestType) == DoubleBlockCombiner.BlockType.FIRST && (blockEntity = level.m_7702_(pos)) instanceof OldChestBlockEntity) {
                    OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
                    entity.invalidateDoubleBlockCache();
                }
                level.m_46717_(pos, newState.m_60734_());
            } else if (oldChestType == EsChestType.SINGLE && newChestType != EsChestType.SINGLE) {
                BlockPos otherPos = pos.m_121945_(AbstractChestBlock.getDirectionToAttached(newState));
                level.m_46717_(otherPos, level.m_8055_(otherPos).m_60734_());
            }
        }
        super.m_6810_(state, level, pos, newState, bl);
    }

    protected boolean areChestsCompatible(Level level, ItemStack itemInHand, BlockPos firstPos, BlockPos secondPos) {
        return true;
    }
}

