/*
 * Decompiled with CFR 0.152.
 */
package com.ddmc.display.blockentity;

import com.ddmc.display.register.ModBlockEntities;
import com.ddmc.display.register.ModBlocks;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class BaseIngotBlockEntity
extends BlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private static final int MAX_ITEM_COUNT = 64;

    public BaseIngotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.BASE_INGOT_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.items, (boolean)true);
        return compoundtag;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean addItem(LivingEntity pEntity, ItemStack heldItem) {
        if (heldItem.m_41619_() || !this.isCorrectItem(heldItem)) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            int heldItemCount = heldItem.m_41613_();
            int stackCount = itemstack.m_41613_();
            if (!itemstack.m_150930_(heldItem.m_41720_()) && !itemstack.m_41619_()) continue;
            if (heldItemCount >= 64 - stackCount) {
                this.items.set(i, (Object)heldItem.m_255036_(64));
                heldItem.m_41620_(64 - stackCount);
            } else {
                this.items.set(i, (Object)heldItem.m_255036_(stackCount + heldItemCount));
                heldItem.m_41620_(heldItemCount);
            }
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)this.m_58900_()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean getItem(LivingEntity pEntity) {
        int i = 0;
        if (i < this.items.size()) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (itemstack.m_41619_()) {
                return false;
            }
            if (pEntity.m_6144_()) {
                pEntity.m_19983_(itemstack);
                this.items.clear();
            } else {
                pEntity.m_19983_(itemstack.m_41620_(1));
            }
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)this.m_58900_()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean isCorrectItem(ItemStack heldItem) {
        BlockState block = this.m_58900_();
        return block.m_60713_((Block)ModBlocks.IRON_INGOT.get()) && heldItem.m_150930_(Items.f_42416_) || block.m_60713_((Block)ModBlocks.GOLD_INGOT.get()) && heldItem.m_150930_(Items.f_42417_) || block.m_60713_((Block)ModBlocks.COPPER_INGOT.get()) && heldItem.m_150930_(Items.f_151052_) || block.m_60713_((Block)ModBlocks.NETHERITE_INGOT.get()) && heldItem.m_150930_(Items.f_42418_);
    }

    public int getItemCount() {
        Iterator iterator = this.items.iterator();
        if (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            int stackCount = itemstack.m_41613_();
            if (stackCount > 32) {
                return (stackCount - 32 - 1) / 8 + 1 + 8;
            }
            return (stackCount - 1) / 4 + 1;
        }
        return 1;
    }

    public NonNullList<ItemStack> getITEMS() {
        return this.items;
    }
}

