/*
 * Decompiled with CFR 0.152.
 */
package com.ddmc.display;

import com.ddmc.display.Config;
import com.ddmc.display.client.BlockFrameBlockRenderer;
import com.ddmc.display.client.DisplayStandBlockRenderer;
import com.ddmc.display.register.ModBlockEntities;
import com.ddmc.display.register.ModBlocks;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="display")
public class Display {
    public static final String MODID = "display";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Display() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246326_((ItemLike)ModBlocks.DISPLAY_STAND_UP.get());
            event.m_246326_((ItemLike)ModBlocks.DISPLAY_STAND_DOWN.get());
            event.m_246326_((ItemLike)ModBlocks.BLOCK_FRAME.get());
            event.m_246326_((ItemLike)ModBlocks.ROTATING_BLOCK_FRAME.get());
            event.m_246326_((ItemLike)ModBlocks.IRON_INGOT.get());
            event.m_246326_((ItemLike)ModBlocks.GOLD_INGOT.get());
            event.m_246326_((ItemLike)ModBlocks.COPPER_INGOT.get());
            event.m_246326_((ItemLike)ModBlocks.NETHERITE_INGOT.get());
        }
    }

    @SubscribeEvent
    public void onItemFrame(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        if (player.m_6144_() && (entity = event.getTarget()) instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (Config.adjustTheItemFrame) {
                itemFrame.m_6842_(!itemFrame.m_20145_());
            }
        }
    }

    @SubscribeEvent
    public void onArmorStand(AttackEntityEvent event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (Config.adjustTheItemFrame) {
                if (player.m_6144_()) {
                    armorStand.m_6842_(!armorStand.m_20145_());
                } else {
                    armorStand.m_20242_(!armorStand.m_20068_());
                }
            }
        }
    }

    @SubscribeEvent
    public void placeIngot(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos().m_6630_(1);
        BlockState blockState = event.getLevel().m_8055_(pos);
        if (player.m_6144_() && Config.placeTheIngot && blockState.m_60795_()) {
            ItemStack itemStack = player.m_21205_();
            Level level = event.getLevel();
            if (itemStack.m_150930_(Items.f_42416_)) {
                level.m_7731_(pos, ((Block)ModBlocks.IRON_INGOT.get()).m_49966_(), 3);
                itemStack.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            if (itemStack.m_150930_(Items.f_42417_)) {
                level.m_7731_(pos, ((Block)ModBlocks.GOLD_INGOT.get()).m_49966_(), 3);
                itemStack.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            if (itemStack.m_150930_(Items.f_151052_)) {
                level.m_7731_(pos, ((Block)ModBlocks.COPPER_INGOT.get()).m_49966_(), 3);
                itemStack.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            if (itemStack.m_150930_(Items.f_42418_)) {
                level.m_7731_(pos, ((Block)ModBlocks.NETHERITE_INGOT.get()).m_49966_(), 3);
                itemStack.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="display", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.DISPLAY_STAND_BLOCK_ENTITY.get(), DisplayStandBlockRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.BLOCK_FRAME_BLOCK_ENTITY.get(), BlockFrameBlockRenderer::new);
        }
    }
}

