/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.client.SkilletBEWLR;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.SkilletItem;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CuisineSkilletItem
extends SkilletItem {
    private static final String KEY_ROOT = "CookingData";

    @Nullable
    public static CookingData getData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(KEY_ROOT);
        if (tag == null) {
            return null;
        }
        return (CookingData)TagCodec.fromTag((CompoundTag)tag, CookingData.class);
    }

    public static void setData(ItemStack stack, @Nullable CookingData data) {
        if (data == null) {
            stack.m_41784_().m_128473_(KEY_ROOT);
            return;
        }
        Tag tag = TagCodec.valueToTag((Object)data);
        if (tag != null) {
            stack.m_41784_().m_128365_(KEY_ROOT, tag);
        }
    }

    public static boolean canUse(ItemStack stack, Player player, Level level) {
        if (CuisineSkilletItem.getData(stack) != null) {
            return true;
        }
        if (stack.getEnchantmentLevel(Enchantments.f_44981_) > 0) {
            return true;
        }
        return CuisineSkilletItem.isPlayerNearHeatSource(player, (LevelReader)level);
    }

    public static void playSound(Player player, Level level, SoundEvent event) {
        Vec3 pos = player.m_20182_();
        double x = pos.m_7096_() + 0.5;
        double y = pos.m_7098_();
        double z = pos.m_7094_() + 0.5;
        level.m_7785_(x, y, z, event, SoundSource.BLOCKS, 0.4f, level.f_46441_.m_188501_() * 0.2f + 0.9f, false);
    }

    public CuisineSkilletItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack skilletStack = player.m_21120_(hand);
        if (!CuisineSkilletItem.canUse(skilletStack, player, level)) {
            if (!level.m_5776_()) {
                ((ServerPlayer)player).m_240418_((Component)LangData.MSG_NO_HEAT.get(new Object[0]), true);
            }
            return InteractionResultHolder.m_19100_((Object)skilletStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data != null && data.contents.size() >= (Integer)CDConfig.COMMON.maxIngredient.get()) {
            if (!level.m_5776_()) {
                ((ServerPlayer)player).m_240418_((Component)LangData.MSG_FULL.get(new Object[0]), true);
            }
            return InteractionResultHolder.m_19100_((Object)skilletStack);
        }
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherStack = player.m_21120_(otherHand);
        if (!otherStack.m_41619_()) {
            IngredientConfig.IngredientEntry entry = IngredientConfig.get().getEntry(otherStack);
            if (entry != null) {
                if (!level.m_5776_()) {
                    long time = level.m_46467_();
                    if (data == null) {
                        data = new CookingData();
                    }
                    int amount = 1 + this.getEnchantmentLevel(skilletStack, Enchantments.f_44984_);
                    int speed = this.getEnchantmentLevel(skilletStack, Enchantments.f_44981_);
                    if (speed == 1) {
                        data.setSpeed(0.5f);
                    }
                    ItemStack toAdd = otherStack.m_41620_(amount);
                    data.addItem(toAdd, time);
                    ItemStack remain = toAdd.getCraftingRemainingItem();
                    remain.m_41764_(toAdd.m_41613_());
                    player.m_150109_().m_150079_(remain);
                    CuisineSkilletItem.setData(skilletStack, data);
                } else {
                    CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get());
                }
            } else if (!level.m_5776_()) {
                ((ServerPlayer)player).m_240418_((Component)LangData.MSG_NOT_INGREDIENT.get(new Object[0]), true);
            }
        } else if (!level.m_5776_()) {
            ((ServerPlayer)player).m_240418_((Component)LangData.MSG_PLACE_HELP.get(new Object[0]), true);
        }
        return InteractionResultHolder.m_19100_((Object)skilletStack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        if (level.m_5776_() && entity instanceof Player && ((player = (Player)entity).m_21205_() == stack || player.m_21206_() == stack) && level.m_213780_().m_188503_(10) == 0 && CuisineSkilletItem.canUse(stack, player, level) && CuisineSkilletItem.getData(stack) != null) {
            CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SkilletBEWLR.EXTENSIONS);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)pos, (ItemStack)stack);
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)tileEntity;
            be.setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        return stack;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
    }

    private static boolean isPlayerNearHeatSource(Player player, LevelReader level) {
        if (player.m_6060_()) {
            return true;
        }
        BlockPos pos = player.m_20183_();
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            if (!level.m_8055_(nearbyPos).m_204336_(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44981_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.USE_SPATULA.get(CDItems.SPATULA.asStack().m_41786_().m_6881_().m_130940_(ChatFormatting.YELLOW)));
        list.add((Component)LangData.USE_PLATE.get(CDItems.PLATE.asStack().m_41786_().m_6881_().m_130940_(ChatFormatting.YELLOW)));
        if (Screen.m_96638_()) {
            list.add((Component)LangData.ENCH_FIRE.get(new Object[0]));
            list.add((Component)LangData.ENCH_EFFICIENCY.get(new Object[0]));
        } else {
            list.add((Component)LangData.ENCH_SHIFT.get(new Object[0]));
        }
    }
}

