/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class PlayerHandler {
    public static InteractionHand getOppositeHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @Nullable
    public static InteractionResult onPlayerEntityInteract(Entity target, UseOnContext context) {
        boolean isClient = target.m_9236_().m_5776_();
        Player player = context.m_43723_();
        if (!(player instanceof ISilkLeashState)) {
            return null;
        }
        ISilkLeashState playerLeashState = (ISilkLeashState)player;
        if (!(target instanceof LivingEntity)) {
            return null;
        }
        LivingEntity entity = (LivingEntity)target;
        ItemStack handStack = context.m_43722_();
        ItemStack otherHandStack = context.m_43723_().m_21120_(PlayerHandler.getOppositeHand(context.m_43724_()));
        Set<LivingEntity> playerLeashingEntities = playerLeashState.getLeashingEntities();
        if (otherHandStack.m_150930_((Item)CACItems.SILK_LEAD.get())) {
            return null;
        }
        if ((playerLeashingEntities.isEmpty() || playerLeashingEntities.contains(entity)) && !handStack.m_150930_((Item)CACItems.SILK_LEAD.get()) && !handStack.m_150930_(Items.f_42655_) && context.m_43724_() == InteractionHand.MAIN_HAND) {
            int unleashedStates = 0;
            unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(entity, null) - 1);
            if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, entity) - 1)) > 0) {
                ItemEntity leadEntity = new ItemEntity(context.m_43725_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedStates));
                context.m_43725_().m_7967_((Entity)leadEntity);
                playerLeashState.sendLeashState();
                if (entity instanceof ISilkLeashState) {
                    ISilkLeashState entityLeashState = (ISilkLeashState)entity;
                    entityLeashState.sendLeashState();
                }
                return InteractionResult.m_19078_((boolean)isClient);
            }
        } else {
            LivingEntity uniqueLeash = (LivingEntity)Iterables.getFirst(playerLeashingEntities, null);
            if (uniqueLeash != null && SilkLeashItem.updateLeashStates(uniqueLeash, entity) != 0) {
                SilkLeashItem.updateLeashStates((LivingEntity)context.m_43723_(), null);
                return InteractionResult.m_19078_((boolean)isClient);
            }
        }
        return null;
    }

    public static void onPlayerTick(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        List nearKoiFishes = player.m_9236_().m_6443_(KoiFishEntity.class, player.m_20191_().m_82400_(10.0), EntitySelector.f_20402_);
        if (nearKoiFishes.size() >= 3) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 210, 0, false, false));
        }
    }

    public static void onPlayerStartTracking(Entity target, Entity from) {
        if (target instanceof LivingEntity) {
            LivingEntity trackedEntity = (LivingEntity)target;
            if (from instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)from;
                if (target instanceof ISilkLeashState) {
                    ISilkLeashState trackedState = (ISilkLeashState)target;
                    CACPacketHandler.SILK_LEASH_STATE.sendToPlayer(player, new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(trackedEntity.m_19879_(), (IntList)new IntArrayList(trackedState.getLeashingEntities().stream().mapToInt(Entity::m_19879_).toArray()), (IntList)new IntArrayList(trackedState.getLeashedByEntities().stream().mapToInt(Entity::m_19879_).toArray()))));
                }
            }
        }
        if (target instanceof Player) {
            Player trackedPlayer = (Player)target;
            if (from instanceof ServerPlayer) {
                ServerPlayer fromPlayer = (ServerPlayer)from;
                IBubbleState bubbleState = (IBubbleState)trackedPlayer;
                IGrapplingState grappleState = (IGrapplingState)trackedPlayer;
                CACPacketHandler.BUBBLE_STATE.sendToPlayer(fromPlayer, new ClientboundBubbleStatePacket(bubbleState.isBubbleActive(), trackedPlayer.m_19879_()));
                CACPacketHandler.GRAPPLING_STATE.sendToPlayer(fromPlayer, new ClientboundGrapplingStatePacket(grappleState.getHook() != null ? Optional.of(grappleState.getHook().m_19879_()) : Optional.empty(), trackedPlayer.m_19879_()));
            }
        }
    }

    public static void onPlayerStopTracking(Entity target, Entity by) {
        DumboOctopusEntity dumboOctopus;
        if (target instanceof DumboOctopusEntity && (dumboOctopus = (DumboOctopusEntity)target).getBubbledPlayer() == by) {
            dumboOctopus.sendBubble((ServerPlayer)by, false);
        }
    }
}

