/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.creeperfirework.mixin;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.creeperfirework.Configuration;
import plus.dragons.creeperfirework.FireworkEffect;
import plus.dragons.creeperfirework.mixin.ExplosionMethodInvoker;

@Mixin(value={Creeper.class})
public abstract class CreeperEntityMixin
extends Monster {
    @Shadow
    private int f_32272_;
    @Final
    @Shadow
    private static EntityDataAccessor<Boolean> f_32274_;

    protected CreeperEntityMixin(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"explode"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/world/World$ExplosionSourceType;)Lnet/minecraft/world/explosion/Explosion;")}, cancellable=true)
    private void injected(CallbackInfo ci) {
        if (Configuration.isCreeperExplodeIntoFirework() && Math.random() < Configuration.becomeFireworkChance()) {
            FireworkEffect.create((Creeper)this);
            if (Configuration.isFireworkHurtCreature()) {
                this.simulateExplodeHurtMob();
            }
            if (Configuration.isFireworkDestroyBlock() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                this.simulateExplodeDestroyBlock();
            }
            this.m_146870_();
            ci.cancel();
        }
    }

    private float getExplosionPower() {
        return (Boolean)this.m_20088_().m_135370_(f_32274_) != false ? (float)(this.f_32272_ * 2) : (float)this.f_32272_;
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (!this.m_9236_().m_5776_() && Configuration.isCreeperExplodeIntoFireworkWhenDie() && Math.random() < Configuration.becomeFireworkChanceWhenDie()) {
            FireworkEffect.create((Creeper)this);
            if (Configuration.isDeathFireworkHurtCreature()) {
                this.simulateExplodeHurtMob();
            }
            if (Configuration.isDeathFireworkDestroyBlock() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                this.simulateExplodeDestroyBlock();
            }
        }
    }

    private void simulateExplodeHurtMob() {
        Vec3 groundZero = this.m_20182_();
        AABB box = new AABB(this.m_20183_()).m_82400_((double)this.getExplosionPower());
        List victims = this.m_9236_().m_45976_(LivingEntity.class, box);
        victims.remove((Object)this);
        for (LivingEntity victim : victims) {
            double u;
            double t;
            double s;
            double blockPos;
            if (victim.m_6128_()) continue;
            float j = this.getExplosionPower() * 2.0f;
            double h = Math.sqrt(victim.m_20238_(groundZero)) / (double)j;
            if (!(h <= 1.0) || (blockPos = Math.sqrt((s = victim.m_20185_() - groundZero.f_82479_) * s + (t = victim.m_20188_() - groundZero.f_82480_) * t + (u = victim.m_20189_() - groundZero.f_82481_) * u)) == 0.0) continue;
            s /= blockPos;
            t /= blockPos;
            u /= blockPos;
            double fluidState = Explosion.m_46064_((Vec3)groundZero, (Entity)victim);
            double v = (1.0 - h) * fluidState;
            victim.m_6469_(this.m_269291_().m_269036_((Entity)((Creeper)this), null), (float)((int)((v * v + v) / 2.0 * 7.0 * (double)j + 1.0)));
            double w = ProtectionEnchantment.m_45135_((LivingEntity)victim, (double)v);
            victim.m_20256_(victim.m_20184_().m_82520_(s * w, t * w, u * w));
        }
    }

    private void simulateExplodeDestroyBlock() {
        this.m_9236_().m_142346_((Entity)this, GameEvent.f_157812_, this.m_20183_());
        HashSet explosionRange = Sets.newHashSet();
        BlockPos groundZero = this.m_20183_();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d = (float)j / 15.0f * 2.0f - 1.0f;
                    double e = (float)k / 15.0f * 2.0f - 1.0f;
                    double f = (float)l / 15.0f * 2.0f - 1.0f;
                    double g = Math.sqrt(d * d + e * e + f * f);
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = groundZero.m_123341_();
                    double n = groundZero.m_123342_();
                    double o = groundZero.m_123343_();
                    for (float h = this.getExplosionPower() * (0.7f + this.m_9236_().f_46441_.m_188501_() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                        Optional optional;
                        BlockPos blockPos = new BlockPos((int)m, (int)n, (int)o);
                        BlockState blockState = this.m_9236_().m_8055_(blockPos);
                        FluidState fluidState = this.m_9236_().m_6425_(blockPos);
                        if (!this.m_9236_().m_46739_(blockPos)) continue block2;
                        Optional<Object> optional2 = optional = blockState.m_60795_() && fluidState.m_76178_() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(blockState.m_60734_().m_7325_(), fluidState.m_76190_())));
                        if (optional.isPresent()) {
                            h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f) {
                            explosionRange.add(blockPos);
                        }
                        m += d * (double)0.3f;
                        n += e * (double)0.3f;
                        o += f * (double)0.3f;
                    }
                }
            }
        }
        ObjectArrayList blockDropList = new ObjectArrayList();
        Explosion simulateExplosionForParameter = new Explosion(this.m_9236_(), null, null, null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), this.getExplosionPower(), false, Explosion.BlockInteraction.DESTROY);
        for (BlockPos affectedPos : explosionRange) {
            BlockState blockStateOfAffected = this.m_9236_().m_8055_(affectedPos);
            Block block = blockStateOfAffected.m_60734_();
            if (blockStateOfAffected.m_60795_()) continue;
            BlockPos blockPos2 = affectedPos.m_7949_();
            this.m_9236_().m_46473_().m_6180_("explosion_blocks");
            BlockEntity blockEntity = blockStateOfAffected.m_155947_() ? this.m_9236_().m_7702_(affectedPos) : null;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)affectedPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.getExplosionPower()));
            blockStateOfAffected.m_287290_(builder).forEach(stack -> ExplosionMethodInvoker.invokeTryMergeStack((ObjectArrayList<Pair<ItemStack, BlockPos>>)blockDropList, stack, blockPos2));
            this.m_9236_().m_7731_(affectedPos, Blocks.f_50016_.m_49966_(), 3);
            block.m_7592_(this.m_9236_(), affectedPos, simulateExplosionForParameter);
            this.m_9236_().m_46473_().m_7238_();
        }
        for (Pair itemStackBlockPosPair : blockDropList) {
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)((BlockPos)itemStackBlockPosPair.getSecond()), (ItemStack)((ItemStack)itemStackBlockPosPair.getFirst()));
        }
    }
}

