/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics.option;

import net.minecraft.nbt.CompoundTag;
import thetadev.constructionwand.api.IWandUpgrade;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandUpgrades;

public class WandUpgradesSelectable<T extends IWandUpgrade>
extends WandUpgrades<T>
implements IOption<T> {
    private byte selector;

    public WandUpgradesSelectable(CompoundTag tag, String key, T dval) {
        super(tag, key, dval);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValueString() {
        return this.get().getRegistryName().toString();
    }

    @Override
    public void setValueString(String val) {
        for (int i = 0; i < this.upgrades.size(); i = (int)((byte)(i + 1))) {
            if (!((IWandUpgrade)this.upgrades.get(i)).getRegistryName().toString().equals(val)) continue;
            this.selector = (byte)i;
            this.serializeSelector();
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.upgrades.size() > 1;
    }

    @Override
    public void set(T val) {
        this.selector = (byte)this.upgrades.indexOf(val);
        this.fixSelector();
        this.serializeSelector();
    }

    @Override
    public T get() {
        this.fixSelector();
        return (T)((IWandUpgrade)this.upgrades.get(this.selector));
    }

    @Override
    public T next(boolean dir) {
        this.selector = (byte)(this.selector + 1);
        this.fixSelector();
        this.serializeSelector();
        return (T)this.get();
    }

    private void fixSelector() {
        if (this.selector < 0 || this.selector >= this.upgrades.size()) {
            this.selector = 0;
        }
    }

    @Override
    protected void deserialize() {
        super.deserialize();
        this.selector = this.tag.m_128445_(this.key + "_sel");
        this.fixSelector();
    }

    @Override
    protected void serialize() {
        super.serialize();
        this.serializeSelector();
    }

    private void serializeSelector() {
        this.tag.m_128344_(this.key + "_sel", this.selector);
    }
}

