/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.util;

import io.wispforest.condensed_creative.entry.Entry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CondensedInventory
extends SimpleContainer {
    private final NonNullList<Entry> entryStacks;

    public CondensedInventory(int size) {
        super(size);
        this.entryStacks = NonNullList.m_122780_((int)size, (Object)Entry.EMPTY_ENTRY);
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.entryStacks.size() ? ((Entry)this.entryStacks.get(slot)).getEntryStack() : ItemStack.f_41583_;
    }

    public Entry getEntryStack(int slot) {
        return slot >= 0 && slot < this.entryStacks.size() ? (Entry)this.entryStacks.get(slot) : Entry.EMPTY_ENTRY;
    }

    public List<ItemStack> m_19195_() {
        List<ItemStack> list = this.entryStacks.stream().filter(entry -> !entry.isEmpty()).map(Entry::getEntryStack).collect(Collectors.toList());
        this.m_6211_();
        return list;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.getItemStackList(), (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_19170_(Item item, int count) {
        ItemStack itemStack = new ItemStack((ItemLike)item, 0);
        for (int i = this.f_19146_ - 1; i >= 0; --i) {
            ItemStack itemStack2 = this.m_8020_(i);
            if (!itemStack2.m_41720_().equals(item)) continue;
            int j = count - itemStack.m_41613_();
            ItemStack itemStack3 = itemStack2.m_41620_(j);
            itemStack.m_41769_(itemStack3.m_41613_());
            if (itemStack.m_41613_() == count) break;
        }
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public boolean m_19183_(ItemStack stack) {
        boolean bl = false;
        for (ItemStack itemStack : this.getItemStackList()) {
            if (!itemStack.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack) || itemStack.m_41613_() >= itemStack.m_41741_())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemStack = this.m_8020_(slot);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.entryStacks.set(slot, (Object)Entry.EMPTY_ENTRY);
        return itemStack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.entryStacks.set(slot, (Object)Entry.of(stack));
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void setEntryStack(int slot, Entry entryStack) {
        this.entryStacks.set(slot, (Object)entryStack);
        ItemStack stack = entryStack.getEntryStack();
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.getItemStackList()) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.entryStacks.clear();
        this.m_6211_();
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack itemStack : this.getItemStackList()) {
            finder.m_36491_(itemStack);
        }
    }

    public String toString() {
        return this.entryStacks.stream().filter(entry -> !entry.isEmpty()).map(Object::toString).collect(Collectors.toList()).toString();
    }

    public void m_7797_(ListTag nbtList) {
        for (int i = 0; i < nbtList.size(); ++i) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbtList.m_128728_(i));
            if (itemStack.m_41619_()) continue;
            this.m_19173_(itemStack);
        }
    }

    private List<ItemStack> getItemStackList() {
        return this.entryStacks.stream().map(Entry::getEntryStack).toList();
    }
}

