/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.registry;

import com.mojang.logging.LogUtils;
import io.wispforest.condensed_creative.LoaderSpecificUtils;
import io.wispforest.condensed_creative.entry.impl.CondensedItemEntry;
import io.wispforest.condensed_creative.registry.CondensedCreativeInitializer;
import io.wispforest.condensed_creative.util.ItemGroupHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public final class CondensedEntryRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<ItemGroupHelper, List<CondensedItemEntry>> ENTRYPOINT_LOADED_ENTRIES = new HashMap<ItemGroupHelper, List<CondensedItemEntry>>();
    public static final Map<ItemGroupHelper, List<CondensedItemEntry>> RESOURCE_LOADED_ENTRIES = new HashMap<ItemGroupHelper, List<CondensedItemEntry>>();

    public static CondensedItemEntry.Builder of(ResourceLocation identifier, ItemLike itemConvertible, Predicate<Item> predicte) {
        return CondensedEntryRegistry.of(identifier, itemConvertible.m_5456_().m_7968_(), predicte);
    }

    public static CondensedItemEntry.Builder of(ResourceLocation identifier, ItemStack stack, Predicate<Item> predicte) {
        return new CondensedItemEntry.Builder(identifier, stack, predicte, null);
    }

    public static <T extends ItemLike> CondensedItemEntry.Builder fromTag(ResourceLocation identifier, ItemLike itemConvertible, TagKey<T> tagKey) {
        return CondensedEntryRegistry.fromTag(identifier, itemConvertible.m_5456_().m_7968_(), tagKey);
    }

    public static <T extends ItemLike> CondensedItemEntry.Builder fromTag(ResourceLocation identifier, ItemStack stack, TagKey<T> tagKey) {
        return new CondensedItemEntry.Builder(identifier, stack, null, tagKey);
    }

    @Deprecated(forRemoval=true)
    public static CondensedItemEntry.Builder fromItemTag(ResourceLocation identifier, ItemLike itemConvertible, TagKey<Item> itemTagKey) {
        return CondensedEntryRegistry.fromItemTag(identifier, itemConvertible.m_5456_().m_7968_(), itemTagKey);
    }

    @Deprecated(forRemoval=true)
    public static CondensedItemEntry.Builder fromItemTag(ResourceLocation identifier, ItemStack stack, TagKey<Item> itemTagKey) {
        return CondensedEntryRegistry.fromTag(identifier, stack, itemTagKey);
    }

    @Deprecated(forRemoval=true)
    public static CondensedItemEntry.Builder fromBlockTag(ResourceLocation identifier, ItemLike itemConvertible, TagKey<Block> blockTagKey) {
        return CondensedEntryRegistry.fromBlockTag(identifier, itemConvertible.m_5456_().m_7968_(), blockTagKey);
    }

    @Deprecated(forRemoval=true)
    public static CondensedItemEntry.Builder fromBlockTag(ResourceLocation identifier, ItemStack stack, TagKey<Block> blockTagKey) {
        return CondensedEntryRegistry.fromTag(identifier, stack, blockTagKey);
    }

    public static <I extends ItemLike> CondensedItemEntry.Builder fromItems(ResourceLocation identifier, ItemLike itemConvertible, Collection<I> collection) {
        return CondensedEntryRegistry.fromItems(identifier, itemConvertible.m_5456_().m_7968_(), collection);
    }

    public static <I extends ItemLike> CondensedItemEntry.Builder fromItems(ResourceLocation identifier, ItemStack stack, Collection<I> collection) {
        return CondensedEntryRegistry.fromItemStacks(identifier, stack, (Collection<ItemStack>)collection.stream().map(ItemLike::m_5456_).map(Item::m_7968_).collect(Collectors.toList()));
    }

    public static CondensedItemEntry.Builder fromItemStacks(ResourceLocation identifier, ItemLike itemConvertible, Collection<ItemStack> collection) {
        return CondensedEntryRegistry.fromItemStacks(identifier, itemConvertible.m_5456_().m_7968_(), collection);
    }

    public static CondensedItemEntry.Builder fromItemStacks(ResourceLocation identifier, ItemStack stack, Collection<ItemStack> collection) {
        return new CondensedItemEntry.Builder(identifier, stack, collection);
    }

    public static CondensedItemEntry.Builder ofSupplier(ResourceLocation identifier, ItemLike itemConvertible, Supplier<List<ItemStack>> entryListSupplier) {
        return CondensedEntryRegistry.ofSupplier(identifier, itemConvertible.m_5456_().m_7968_(), entryListSupplier);
    }

    public static CondensedItemEntry.Builder ofSupplier(ResourceLocation identifier, ItemStack stack, Supplier<List<ItemStack>> entryListSupplier) {
        return new CondensedItemEntry.Builder(identifier, stack, entryListSupplier);
    }

    public static List<CondensedItemEntry> getEntryList(ItemGroupHelper itemGroupHelper) {
        ArrayList<CondensedItemEntry> entries = new ArrayList<CondensedItemEntry>();
        if (ENTRYPOINT_LOADED_ENTRIES.containsKey(itemGroupHelper)) {
            entries.addAll((Collection)ENTRYPOINT_LOADED_ENTRIES.get(itemGroupHelper));
        }
        if (RESOURCE_LOADED_ENTRIES.containsKey(itemGroupHelper)) {
            entries.addAll((Collection<CondensedItemEntry>)RESOURCE_LOADED_ENTRIES.get(itemGroupHelper));
        }
        return entries;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void addCondensedEntryToRegistryMap(CondensedItemEntry condensedItemEntry, Map<ItemGroupHelper, List<CondensedItemEntry>> entriesMap) {
        if (condensedItemEntry.getItemGroupInfo() != null) {
            if (entriesMap.containsKey(condensedItemEntry.getItemGroupInfo())) {
                entriesMap.get(condensedItemEntry.getItemGroupInfo()).add(condensedItemEntry);
            } else {
                ArrayList<CondensedItemEntry> list = new ArrayList<CondensedItemEntry>();
                list.add(condensedItemEntry);
                entriesMap.put(condensedItemEntry.getItemGroupInfo(), list);
            }
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void removeCondensedEntryToMainList(CondensedItemEntry condensedItemEntry) {
        if (condensedItemEntry.getItemGroupInfo() != null && ENTRYPOINT_LOADED_ENTRIES.containsKey(condensedItemEntry.getItemGroupInfo())) {
            ENTRYPOINT_LOADED_ENTRIES.get(condensedItemEntry.getItemGroupInfo()).remove(condensedItemEntry);
        }
    }

    @ApiStatus.Internal
    public static boolean refreshEntrypoints() {
        int previousSize = 0;
        int currentSize = 0;
        for (Map.Entry<ItemGroupHelper, List<CondensedItemEntry>> entry : ENTRYPOINT_LOADED_ENTRIES.entrySet()) {
            previousSize += entry.getValue().size();
        }
        ENTRYPOINT_LOADED_ENTRIES.clear();
        for (CondensedCreativeInitializer condensedCreativeInitializer : LoaderSpecificUtils.getEntryPoints()) {
            condensedCreativeInitializer.onInitializeCondensedEntries(true);
        }
        for (Map.Entry entry : ENTRYPOINT_LOADED_ENTRIES.entrySet()) {
            currentSize += ((List)entry.getValue()).size();
        }
        return previousSize != currentSize;
    }
}

