/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.mixins.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.condensed_creative.CondensedCreative;
import io.wispforest.condensed_creative.compat.CondensedCreativeConfig;
import io.wispforest.condensed_creative.entry.Entry;
import io.wispforest.condensed_creative.entry.impl.CondensedItemEntry;
import io.wispforest.condensed_creative.util.CondensedInventory;
import me.shedaniel.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin<T extends AbstractContainerMenu> {
    @Unique
    private static final ResourceLocation PLUS_ICON = CondensedCreative.createID("textures/gui/plus_logo.png");
    @Unique
    private static final ResourceLocation MINUS_ICON = CondensedCreative.createID("textures/gui/minus_logo.png");

    @ModifyVariable(method={"drawSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/slot/Slot;getStack()Lnet/minecraft/item/ItemStack;", ordinal=0, shift=At.Shift.BY, by=2))
    private ItemStack changeDisplayedStackIfParent(ItemStack stack, GuiGraphics matrices, Slot slot) {
        CondensedInventory condensedInventory;
        Entry entry;
        Container container = slot.f_40218_;
        if (container instanceof CondensedInventory && (entry = (condensedInventory = (CondensedInventory)container).getEntryStack(slot.f_40219_)) instanceof CondensedItemEntry) {
            CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entry;
            if (!condensedItemEntry.isChild) {
                if (Minecraft.m_91087_().f_91073_.m_46467_() - condensedItemEntry.lastTick > 40L) {
                    condensedItemEntry.getNextValue();
                    condensedItemEntry.lastTick = Minecraft.m_91087_().f_91073_.m_46467_();
                }
                return condensedItemEntry.getDisplayStack();
            }
        }
        return stack;
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", shift=At.Shift.BY, by=1)})
    private void renderExtraIfEntry(GuiGraphics context, Slot slot, CallbackInfo ci) {
        CondensedInventory condensedInventory;
        Entry entryStack;
        Container container;
        if ((AbstractContainerScreen)this instanceof CreativeModeInventoryScreen && (container = slot.f_40218_) instanceof CondensedInventory && (entryStack = (condensedInventory = (CondensedInventory)container).getEntryStack(slot.m_150661_())) instanceof CondensedItemEntry) {
            CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entryStack;
            int minX = slot.f_40220_;
            int minY = slot.f_40221_;
            int maxX = minX + 16;
            int maxY = minY + 16;
            if (CondensedItemEntry.CHILD_VISIBILITY.get(condensedItemEntry.condensedID).booleanValue()) {
                Color backgroundColor = Color.ofTransparent((int)0x7F111111);
                if (((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).entryBackgroundColor) {
                    if (((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).entryBorderColor) {
                        context.m_280509_(minX, minY, maxX, maxY, backgroundColor.getColor());
                    } else {
                        context.m_280509_(minX - 1, minY - 1, maxX + 1, maxY + 1, backgroundColor.getColor());
                    }
                }
                if (((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).entryBorderColor) {
                    RenderSystem.enableBlend();
                    Color outlineColor = Color.ofTransparent((int)((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).condensedEntryBorderColor);
                    if (!this.isSlotAbovePartOfCondensedEntry(slot, condensedItemEntry.condensedID)) {
                        context.m_280509_(minX - 1, minY - 1, maxX + 1, maxY - 16, outlineColor.getColor());
                    }
                    if (!this.isSlotBelowPartOfCondensedEntry(slot, condensedItemEntry.condensedID)) {
                        context.m_280509_(minX - 1, minY + 16, maxX + 1, maxY + 1, outlineColor.getColor());
                    }
                    if (!this.isSlotRightPartOfCondensedEntry(slot, condensedItemEntry.condensedID)) {
                        context.m_280509_(minX + 16, minY - 1, maxX + 1, maxY + 1, outlineColor.getColor());
                    }
                    if (!this.isSlotLeftPartOfCondensedEntry(slot, condensedItemEntry.condensedID)) {
                        context.m_280509_(minX - 1, minY - 1, maxX - 16, maxY + 1, outlineColor.getColor());
                    }
                }
                RenderSystem.disableBlend();
            }
            if (!condensedItemEntry.isChild) {
                ResourceLocation id = CondensedItemEntry.CHILD_VISIBILITY.get(condensedItemEntry.condensedID) == false ? PLUS_ICON : MINUS_ICON;
                context.m_280398_(id, minX, minY, 160, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    public boolean isSlotAbovePartOfCondensedEntry(Slot slot, ResourceLocation condensedID) {
        int topSlotIndex = slot.m_150661_() - 9;
        if (topSlotIndex < 0) return false;
        Entry entry = ((CondensedInventory)slot.f_40218_).getEntryStack(topSlotIndex);
        if (!(entry instanceof CondensedItemEntry)) return false;
        CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entry;
        if (condensedID != condensedItemEntry.condensedID) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    public boolean isSlotBelowPartOfCondensedEntry(Slot slot, ResourceLocation condensedID) {
        int bottomSlotIndex = slot.m_150661_() + 9;
        if (bottomSlotIndex >= slot.f_40218_.m_6643_()) return false;
        Entry entry = ((CondensedInventory)slot.f_40218_).getEntryStack(bottomSlotIndex);
        if (!(entry instanceof CondensedItemEntry)) return false;
        CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entry;
        if (condensedID != condensedItemEntry.condensedID) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    public boolean isSlotLeftPartOfCondensedEntry(Slot slot, ResourceLocation condensedID) {
        if (slot.f_40219_ % 9 == 0) {
            return false;
        }
        int leftSlotIndex = slot.m_150661_() - 1;
        if (leftSlotIndex >= slot.f_40218_.m_6643_()) return false;
        Entry entry = ((CondensedInventory)slot.f_40218_).getEntryStack(leftSlotIndex);
        if (!(entry instanceof CondensedItemEntry)) return false;
        CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entry;
        if (condensedID != condensedItemEntry.condensedID) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    public boolean isSlotRightPartOfCondensedEntry(Slot slot, ResourceLocation condensedID) {
        if (slot.f_40219_ % 9 == 8) {
            return false;
        }
        int rightSlotIndex = slot.m_150661_() + 1;
        if (rightSlotIndex >= slot.f_40218_.m_6643_()) return false;
        Entry entry = ((CondensedInventory)slot.f_40218_).getEntryStack(rightSlotIndex);
        if (!(entry instanceof CondensedItemEntry)) return false;
        CondensedItemEntry condensedItemEntry = (CondensedItemEntry)entry;
        if (condensedID != condensedItemEntry.condensedID) return false;
        return true;
    }
}

