/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.mixins.client;

import io.wispforest.condensed_creative.CondensedCreative;
import io.wispforest.condensed_creative.compat.CondensedCreativeConfig;
import io.wispforest.condensed_creative.ducks.CreativeInventoryScreenHandlerDuck;
import io.wispforest.condensed_creative.entry.Entry;
import io.wispforest.condensed_creative.entry.impl.CondensedItemEntry;
import io.wispforest.condensed_creative.entry.impl.ItemEntry;
import io.wispforest.condensed_creative.mixins.client.HandledScreenAccessor;
import io.wispforest.condensed_creative.registry.CondensedEntryRegistry;
import io.wispforest.condensed_creative.util.CondensedInventory;
import io.wispforest.condensed_creative.util.ItemGroupHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    @Final
    @Mutable
    public static SimpleContainer f_98505_;
    @Shadow
    private static CreativeModeTab f_98507_;
    @Shadow
    private float f_98508_;
    @Unique
    private static final ResourceLocation refreshButtonIcon;
    @Unique
    private boolean validItemGroupForCondensedEntries = false;
    @Unique
    private float currentRowPosition = 0.0f;

    @Shadow
    protected abstract void m_98560_(CreativeModeTab var1);

    public CreativeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void setupInventory(CallbackInfo ci) {
        f_98505_ = new CondensedInventory(f_98505_.m_6643_());
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/PlayerScreenHandler;addListener(Lnet/minecraft/screen/ScreenHandlerListener;)V", shift=At.Shift.BY, by=2)})
    private void addButtonRender(CallbackInfo ci) {
        if (!((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).entryRefreshButton) {
            return;
        }
        ImageButton widget = new ImageButton(this.f_97735_ + 200, this.f_97736_ + 140, 16, 16, 0, 0, 16, refreshButtonIcon, 32, 32, button -> {
            if (CondensedEntryRegistry.refreshEntrypoints()) {
                this.m_98560_(f_98507_);
            }
        }, CommonComponents.f_237098_);
        widget.m_257544_(Tooltip.m_257550_((Component)Component.m_130674_((String)"Refresh Condensed Entries")));
        this.m_142416_((GuiEventListener)widget);
    }

    @Inject(method={"getTooltipFromItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void testToReplaceTooltipText(ItemStack stack, CallbackInfoReturnable<List<Component>> cir) {
        Object object;
        Slot slot = ((HandledScreenAccessor)((Object)this)).cc$getFocusedSlot();
        if (slot != null && (object = slot.f_40218_) instanceof CondensedInventory) {
            CondensedInventory inv = (CondensedInventory)((Object)object);
            if (ItemEntry.areStacksEqual(slot.m_7993_(), stack) && (object = inv.getEntryStack(slot.f_40219_)) instanceof CondensedItemEntry) {
                CondensedItemEntry entry = (CondensedItemEntry)object;
                if (!entry.isChild) {
                    ArrayList<Component> tooltipData = new ArrayList<Component>();
                    entry.getParentTooltipText(tooltipData, (Player)this.f_96541_.f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                    cir.setReturnValue(tooltipData);
                }
            }
        }
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;clear()V", ordinal=0)})
    private void setSelectedTab$clearEntryList(CreativeModeTab group, CallbackInfo ci) {
        this.getHandlerDuck().getDefaultEntryList().clear();
        this.validItemGroupForCondensedEntries = false;
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;add(Ljava/lang/Object;)Z", ordinal=0, shift=At.Shift.BY, by=2), @At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;add(Ljava/lang/Object;)Z", ordinal=1, shift=At.Shift.BY, by=2)})
    private void setSelectedTab$addStackToEntryList(CreativeModeTab group, CallbackInfo ci) {
        this.getHandlerDuck().addToDefaultEntryList((ItemStack)((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).f_98639_.get(((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).f_98639_.size() - 1));
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;addAll(Ljava/util/Collection;)Z", ordinal=0, shift=At.Shift.BY, by=2), @At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;addAll(Ljava/util/Collection;)Z", ordinal=1, shift=At.Shift.BY, by=1)})
    private void setSelectedTab$addStacksToEntryList(CreativeModeTab group, CallbackInfo ci) {
        ((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).f_98639_.forEach(stack -> this.getHandlerDuck().addToDefaultEntryList((ItemStack)stack));
        if (group != BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256917_)) {
            this.validItemGroupForCondensedEntries = true;
        }
    }

    @Inject(method={"search"}, at={@At(value="HEAD")})
    private void search$clearEntryList(CallbackInfo ci) {
        this.getHandlerDuck().getDefaultEntryList().clear();
    }

    @Inject(method={"search"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;scrollItems(F)V", shift=At.Shift.BY, by=-2)})
    private void search$addStacksToEntryList(CallbackInfo ci) {
        ((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).f_98639_.forEach(stack -> this.getHandlerDuck().addToDefaultEntryList((ItemStack)stack));
    }

    @Redirect(method={"setSelectedTab", "search"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;scrollItems(F)V"))
    private void scrollLineCountDefault(CreativeModeInventoryScreen.ItemPickerMenu instance, float position) {
        this.getHandlerDuck().markEntryListDirty();
        this.calculateScrollLines(0.0f, 0.0f);
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="JUMP", opcode=166, ordinal=2)})
    private void filterEntriesAndAddCondensedEntries(CreativeModeTab group, CallbackInfo ci) {
        ItemGroupHelper itemGroupHelper = ItemGroupHelper.of(group, CondensedCreative.isOwoItemGroup.test(group) ? CondensedCreative.getTabIndexFromOwoGroup.apply(group) : 0);
        if (!this.validItemGroupForCondensedEntries) {
            return;
        }
        for (CondensedItemEntry condensedItemEntry : CondensedEntryRegistry.getEntryList(itemGroupHelper)) {
            int i = this.getHandlerDuck().getDefaultEntryList().indexOf((Object)Entry.of(condensedItemEntry.getEntryStack()));
            condensedItemEntry.initializeChildren((List<Entry>)this.getHandlerDuck().getDefaultEntryList());
            ArrayList<CondensedItemEntry> allGroupedEntries = new ArrayList<CondensedItemEntry>(condensedItemEntry.childrenEntry);
            allGroupedEntries.add(0, condensedItemEntry);
            if (allGroupedEntries.size() <= 1) continue;
            if (i >= 0 && i < this.getHandlerDuck().getDefaultEntryList().size()) {
                this.getHandlerDuck().getDefaultEntryList().addAll(i, allGroupedEntries);
                continue;
            }
            this.getHandlerDuck().getDefaultEntryList().addAll(allGroupedEntries);
        }
    }

    @Inject(method={"onMouseClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkIfCondensedEntryWithinSlot(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        CondensedInventory inv;
        Object object;
        if (slot != null && (object = slot.f_40218_) instanceof CondensedInventory && (object = (inv = (CondensedInventory)((Object)object)).getEntryStack(slotId)) instanceof CondensedItemEntry) {
            CondensedItemEntry entry = (CondensedItemEntry)object;
            if (!entry.isChild) {
                entry.toggleVisibility();
                this.getHandlerDuck().markEntryListDirty();
                this.getHandlerDuck().scrollItems(Math.round(this.currentRowPosition));
                if (this.currentRowPosition > (float)this.getHandlerDuck().getMaxRowCount()) {
                    this.currentRowPosition = this.getHandlerDuck().getMaxRowCount();
                    this.getHandlerDuck().scrollItems(Math.round(this.currentRowPosition));
                }
                ci.cancel();
            }
        }
    }

    @ModifyArg(method={"drawBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal=1), index=2)
    private int changePosForScrollBar(int y) {
        int j = this.f_97736_ + 18;
        float scrollPosition = this.currentRowPosition / (float)this.getHandlerDuck().getMaxRowCount();
        if (!Float.isFinite(scrollPosition)) {
            scrollPosition = 0.0f;
        }
        return Math.round((float)j + 95.0f * scrollPosition);
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;scrollItems(F)V"))
    private void useLineCountScrolling1(CreativeModeInventoryScreen.ItemPickerMenu instance, float position, double mouseX, double mouseY, double amount) {
        this.calculateScrollLines(this.currentRowPosition, (float)amount);
    }

    @Redirect(method={"mouseDragged"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;scrollItems(F)V"))
    private void useLineCountScrolling2(CreativeModeInventoryScreen.ItemPickerMenu instance, float position) {
        this.currentRowPosition = this.f_98508_ * (float)this.getHandlerDuck().getMaxRowCount();
        this.calculateScrollLines(this.currentRowPosition, 0.0f);
    }

    @Unique
    private void calculateScrollLines(float currentRowPosition, float amount) {
        float adjustedRowPosition = Mth.m_14036_((float)(currentRowPosition - amount), (float)0.0f, (float)this.getHandlerDuck().getMaxRowCount());
        this.getHandlerDuck().scrollItems(Math.round(adjustedRowPosition));
        this.currentRowPosition = adjustedRowPosition;
    }

    @Unique
    public CreativeInventoryScreenHandlerDuck getHandlerDuck() {
        return (CreativeInventoryScreenHandlerDuck)this.f_97732_;
    }

    static {
        refreshButtonIcon = CondensedCreative.createID("textures/gui/refresh_button.png");
    }

    @Mixin(value={CreativeModeInventoryScreen.ItemPickerMenu.class})
    public static abstract class CreativeInventoryScreenHandlerMixin
    implements CreativeInventoryScreenHandlerDuck {
        @Unique
        private static final Logger LOGGER = LogManager.getLogger((String)"CondensedCreative");
        @Unique
        private boolean isEntryListDirty = true;
        @Unique
        private NonNullList<Entry> defaultEntryList = NonNullList.m_122779_();
        @Unique
        private NonNullList<Entry> filteredEntryList = NonNullList.m_122779_();

        @Shadow
        public abstract boolean m_98654_();

        @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;scrollItems(F)V"))
        private void scrollLineCount(CreativeModeInventoryScreen.ItemPickerMenu instance, float position) {
            this.markEntryListDirty();
            this.scrollItems(0);
        }

        @Redirect(method={"shouldShowScrollbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;size()I"))
        private int redirectListSize(NonNullList instance) {
            return this.filteredEntryList.size();
        }

        @Override
        public void scrollItems(int positionOffset) {
            if (this.isEntryListDirty()) {
                Predicate<Entry> removeNonVisibleEntries = Entry::isVisible;
                this.filteredEntryList.clear();
                this.filteredEntryList.addAll(this.getDefaultEntryList().stream().filter(removeNonVisibleEntries).toList());
                this.isEntryListDirty = false;
            }
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    int m = l + (k + positionOffset) * 9;
                    if (m >= 0 && m < this.filteredEntryList.size()) {
                        ((CondensedInventory)CreativeModeInventoryScreen.f_98505_).setEntryStack(l + k * 9, (Entry)this.filteredEntryList.get(m));
                        continue;
                    }
                    ((CondensedInventory)CreativeModeInventoryScreen.f_98505_).m_6836_(l + k * 9, ItemStack.f_41583_);
                }
            }
        }

        @Override
        public int getMaxRowCount() {
            return !this.getFilteredEntryList().isEmpty() && this.m_98654_() ? Mth.m_14167_((float)((float)this.getFilteredEntryList().size() / 9.0f - 5.0f)) : 0;
        }

        @Override
        public NonNullList<Entry> getFilteredEntryList() {
            return this.filteredEntryList;
        }

        @Override
        public void setFilteredEntryList(NonNullList<Entry> EntryList) {
            this.filteredEntryList = EntryList;
        }

        @Override
        public NonNullList<Entry> getDefaultEntryList() {
            return this.defaultEntryList;
        }

        @Override
        public void setDefaultEntryList(NonNullList<Entry> EntryList) {
            this.defaultEntryList = EntryList;
        }

        @Override
        public void addToDefaultEntryList(ItemStack stack) {
            this.defaultEntryList.add((Object)Entry.of(stack));
        }

        @Override
        public boolean isEntryListDirty() {
            return this.isEntryListDirty;
        }

        @Override
        public void markEntryListDirty() {
            this.isEntryListDirty = true;
        }
    }
}

