/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.entry.impl;

import com.mojang.logging.LogUtils;
import io.wispforest.condensed_creative.CondensedCreative;
import io.wispforest.condensed_creative.compat.CondensedCreativeConfig;
import io.wispforest.condensed_creative.entry.Entry;
import io.wispforest.condensed_creative.entry.impl.ItemEntry;
import io.wispforest.condensed_creative.registry.CondensedEntryRegistry;
import io.wispforest.condensed_creative.util.ItemGroupHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CondensedItemEntry
extends ItemEntry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<ResourceLocation, Boolean> CHILD_VISIBILITY = new HashMap<ResourceLocation, Boolean>();
    public final ResourceLocation condensedID;
    @Nullable
    private Supplier<List<ItemStack>> childrenSupplier = null;
    @Nullable
    private Supplier<Component> condensedEntryTitleBuilder = null;
    private Component condensedEntryTitle;
    private boolean compareToItem = false;
    private ItemGroupHelper itemGroupInfo;
    private EntryOrder listOrder = EntryOrder.DEFAULT_ORDER;
    private boolean removeIfNotFound = false;
    private ItemEntry chosenIconStack = null;
    @Nullable
    private Component descriptionText = null;
    @Nullable
    private Consumer<List<ItemStack>> entrySorting = null;
    @Nullable
    private TagKey<? extends ItemLike> tagKey = null;
    public final boolean isChild;
    public final List<CondensedItemEntry> childrenEntry = new ArrayList<CondensedItemEntry>();
    private ItemEntry currentlyDisplayedEntry;
    public long lastTick = 0L;

    private CondensedItemEntry(ResourceLocation identifier, ItemStack defaultStack, boolean isChild) {
        super(defaultStack);
        this.condensedID = identifier;
        this.isChild = isChild;
        this.condensedEntryTitle = Component.m_130674_((String)Arrays.stream(identifier.m_135815_().split("_")).map(WordUtils::capitalize).collect(Collectors.joining(" ")));
        CHILD_VISIBILITY.put(identifier, false);
    }

    @ApiStatus.Internal
    private static CondensedItemEntry createChild(ResourceLocation condensedID, ItemStack defaultItemstack) {
        return new CondensedItemEntry(condensedID, defaultItemstack, true);
    }

    @ApiStatus.Internal
    public void initializeChildren(List<Entry> itemGroupList) {
        if (this.childrenEntry.isEmpty()) {
            List<ItemStack> childrenStacks = this.getChildren();
            List<ItemStack> replacedStacks = this.filterItemGroupStacks(itemGroupList, childrenStacks.stream().map(ItemEntry::hashcodeOfStack).toList(), true);
            if (this.removeIfNotFound) {
                ArrayList<ItemStack> childrenStacksFiltered = new ArrayList<ItemStack>();
                for (int i = 0; i < childrenStacks.size(); ++i) {
                    ItemStack childrenStack = childrenStacks.get(i);
                    boolean bl = replacedStacks.stream().anyMatch(stack -> ItemEntry.hashcodeOfStack(childrenStack) == ItemEntry.hashcodeOfStack(stack));
                    if (!bl) continue;
                    childrenStacksFiltered.add(childrenStack);
                }
                if (childrenStacks.size() > replacedStacks.size()) {
                    childrenStacks = childrenStacksFiltered;
                }
            }
            if (!childrenStacks.isEmpty()) {
                this.listOrder.sortList(replacedStacks, childrenStacks, this.entrySorting != null ? this.entrySorting : l -> {});
                this.childrenEntry.addAll(childrenStacks.stream().map(stack -> CondensedItemEntry.createChild(this.condensedID, stack)).toList());
            }
        } else {
            this.filterItemGroupStacks(itemGroupList, this.childrenEntry.stream().map(CondensedItemEntry::getItemEntryHashCode).toList(), false);
        }
        if (!this.childrenEntry.isEmpty()) {
            this.getNextValue();
        }
    }

    public List<ItemStack> getChildren() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.childrenSupplier != null) {
            return this.childrenSupplier.get();
        }
        if (this.tagKey != null) {
            BuiltInRegistries.f_257033_.forEach(item1 -> {
                if (this.withinEntriesTag((Item)item1)) {
                    stacks.add(item1.m_7968_());
                }
            });
        }
        return stacks;
    }

    private <T extends ItemLike> boolean withinEntriesTag(Item item) {
        if (this.tagKey == null) {
            return false;
        }
        if (this.tagKey.m_207645_(Registries.f_256913_)) {
            return item.m_204114_().m_203656_(this.tagKey);
        }
        if (this.tagKey.m_207645_(Registries.f_256747_)) {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_204297_().m_203656_(this.tagKey);
        }
        LOGGER.warn("[CondensedEntryRegistry]: It seems that a Condensed Entry was somehow registered with Tag that isn't part of the Item or Block Registry: [Id: {}]", (Object)this.condensedID);
        return false;
    }

    public List<ItemStack> filterItemGroupStacks(List<Entry> itemGroupList, List<Integer> hashValues, boolean returnStacks) {
        ArrayList<ItemStack> replacedStacks = new ArrayList<ItemStack>();
        itemGroupList.removeIf(entry -> {
            if (!(entry instanceof CondensedItemEntry) && hashValues.contains(entry.hashCode())) {
                if (returnStacks) {
                    replacedStacks.add(entry.getEntryStack());
                }
                return true;
            }
            return false;
        });
        return replacedStacks;
    }

    public void getNextValue() {
        if (this.chosenIconStack == null) {
            int index;
            int n = index = ((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).rotationPreview ? new Random().nextInt(0, this.childrenEntry.size()) : 0;
            if (index < 0 || index > this.childrenEntry.size()) {
                this.currentlyDisplayedEntry = ItemEntry.EMPTY;
                LOGGER.error("[CondensedItemEntry]: It seems that a random number generated for the given CondensedEntry[{}] seems to have been out of the valid bounds!", (Object)this.condensedID);
            } else {
                this.currentlyDisplayedEntry = this.childrenEntry.get(index);
            }
        } else if (!this.currentlyDisplayedEntry.equals(this.chosenIconStack)) {
            this.currentlyDisplayedEntry = this.chosenIconStack;
        }
    }

    public ItemGroupHelper getItemGroupInfo() {
        return this.itemGroupInfo;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.isChild ? this.getEntryStack() : this.currentlyDisplayedEntry.getEntryStack();
    }

    @Override
    public boolean isVisible() {
        return this.isChild ? CHILD_VISIBILITY.get(this.condensedID).booleanValue() : super.isVisible();
    }

    @Override
    public void toggleVisibility() {
        if (!this.isChild) {
            CHILD_VISIBILITY.replace(this.condensedID, CHILD_VISIBILITY.get(this.condensedID) == false);
        }
    }

    public void getParentTooltipText(List<Component> tooltipData, Player player, TooltipFlag context) {
        if (this.condensedEntryTitleBuilder != null) {
            this.condensedEntryTitle = this.condensedEntryTitleBuilder.get();
            this.condensedEntryTitleBuilder = null;
        }
        tooltipData.add(this.condensedEntryTitle);
        if (this.descriptionText != null) {
            tooltipData.add(this.descriptionText);
        }
        if (this.tagKey != null && ((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).tagPreviewForEntries) {
            tooltipData.add((Component)Component.m_130674_((String)("Tag: #" + this.tagKey.f_203868_().toString())).m_6881_().m_130940_(ChatFormatting.GRAY));
        }
        if (((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).debugIdentifiersForEntries) {
            tooltipData.add(Component.m_130674_((String)""));
            tooltipData.add((Component)Component.m_130674_((String)("EntryID: " + this.condensedID.toString())).m_6881_().m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public TagKey<?> getTagKey() {
        return this.tagKey;
    }

    public int getItemEntryHashCode() {
        return super.hashCode();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.condensedID.hashCode();
        if (!this.isChild) {
            hash = hash * 31 + this.childrenEntry.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        Entry entry;
        if (this.compareToItem && obj instanceof Entry && !((entry = (Entry)obj) instanceof CondensedItemEntry)) {
            return this.getEntryStack().m_41720_() == entry.getEntryStack().m_41720_();
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return this.isChild ? super.toString() : "ParentEntry: {Id: " + this.condensedID + "}";
    }

    public static enum EntryOrder implements SortingAction
    {
        DEFAULT_ORDER((itemGroupStacks, toBeChildren, customFilter) -> {}),
        ITEMGROUP_ORDER((itemGroupStacks, toBeChildren, customFilter) -> {
            ArrayList<ItemStack> newListOrder = new ArrayList<ItemStack>();
            for (int i = 0; i < itemGroupStacks.size(); ++i) {
                ItemStack currentItemGroupStack = (ItemStack)itemGroupStacks.get(i);
                AtomicReference<ItemStack> foundChildStack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                toBeChildren.removeIf(stack -> {
                    if (ItemEntry.hashcodeOfStack(currentItemGroupStack) == ItemEntry.hashcodeOfStack(stack)) {
                        foundChildStack.set((ItemStack)stack);
                        return true;
                    }
                    return false;
                });
                if (foundChildStack.get() == ItemStack.f_41583_) continue;
                newListOrder.add(foundChildStack.get());
            }
            if (!toBeChildren.isEmpty()) {
                newListOrder.addAll(toBeChildren);
            }
            toBeChildren.clear();
            toBeChildren.addAll(newListOrder);
        }),
        CUSTOM_ORDER((itemGroupStacks, toBeChildren, customFilter) -> customFilter.accept(toBeChildren));

        public SortingAction action;

        private EntryOrder(SortingAction action) {
            this.action = action;
        }

        @Override
        public void sortList(List<ItemStack> itemGroupStacks, List<ItemStack> toBeChildren, Consumer<List<ItemStack>> customFilter) {
            this.action.sortList(itemGroupStacks, toBeChildren, customFilter);
        }
    }

    public static interface SortingAction {
        public void sortList(List<ItemStack> var1, List<ItemStack> var2, Consumer<List<ItemStack>> var3);
    }

    public static class Builder {
        public final CondensedItemEntry currentEntry;

        public Builder(ResourceLocation condensedID, ItemStack defaultItemstack, Supplier<List<ItemStack>> entryListSupplier) {
            this.currentEntry = new CondensedItemEntry(condensedID, defaultItemstack, false);
            this.currentEntry.childrenSupplier = entryListSupplier;
        }

        public Builder(ResourceLocation condensedID, ItemStack defaultItemstack, Collection<ItemStack> entries) {
            this.currentEntry = new CondensedItemEntry(condensedID, defaultItemstack, false);
            this.currentEntry.childrenSupplier = () -> new ArrayList(entries);
        }

        public <T extends ItemLike> Builder(ResourceLocation condensedID, ItemStack defaultItemstack, @Nullable Predicate<Item> entryPredicate, @Nullable TagKey<T> tagKey) {
            this.currentEntry = new CondensedItemEntry(condensedID, defaultItemstack, false);
            if (entryPredicate != null) {
                this.currentEntry.childrenSupplier = () -> {
                    ArrayList stacks = new ArrayList();
                    BuiltInRegistries.f_257033_.forEach(item1 -> {
                        if (entryPredicate.test((Item)item1)) {
                            stacks.add(item1.m_7968_());
                        }
                    });
                    return stacks;
                };
            } else if (tagKey != null) {
                this.currentEntry.tagKey = tagKey;
            } else {
                LOGGER.warn("[CondensedEntryBuilder]: Both the Predicate and the TagKey for a Condensed Entry was found to be null meaning it will be empty on creation: [Id: {}]", (Object)condensedID);
            }
        }

        private Builder(CondensedItemEntry entry) {
            this.currentEntry = new CondensedItemEntry(entry.condensedID, entry.itemStack, false);
            this.currentEntry.condensedEntryTitle = entry.condensedEntryTitle;
            this.currentEntry.compareToItem = entry.compareToItem;
            this.currentEntry.descriptionText = entry.descriptionText;
            this.currentEntry.childrenSupplier = entry.childrenSupplier;
            this.currentEntry.tagKey = entry.tagKey;
            this.currentEntry.entrySorting = entry.entrySorting;
            this.currentEntry.listOrder = entry.listOrder;
            this.currentEntry.removeIfNotFound = entry.removeIfNotFound;
        }

        public Builder useItemComparison(boolean value) {
            this.currentEntry.compareToItem = value;
            return this;
        }

        public Builder setTitleSupplier(Supplier<Component> condensedEntryTitle) {
            this.currentEntry.condensedEntryTitleBuilder = condensedEntryTitle;
            return this;
        }

        public Builder setTitle(Component condensedEntryTitle) {
            this.currentEntry.condensedEntryTitle = condensedEntryTitle;
            return this;
        }

        public Builder setTitleFromTag() {
            if (this.currentEntry.tagKey != null) {
                this.currentEntry.condensedEntryTitle = Component.m_130674_((String)Arrays.stream(this.currentEntry.tagKey.f_203868_().m_135815_().split("_")).map(WordUtils::capitalize).collect(Collectors.joining(" ")));
            }
            return this;
        }

        public Builder setDescription(Component description) {
            this.currentEntry.descriptionText = description;
            return this;
        }

        public Builder setEntrySorting(Consumer<List<ItemStack>> sortFunc) {
            this.currentEntry.entrySorting = sortFunc;
            this.currentEntry.listOrder = EntryOrder.CUSTOM_ORDER;
            return this;
        }

        public Builder setEntryOrder(EntryOrder entryOrder) {
            this.currentEntry.listOrder = entryOrder;
            return this;
        }

        public Builder toggleStrictFiltering(boolean value) {
            this.currentEntry.removeIfNotFound = value;
            return this;
        }

        public CondensedItemEntry addToItemGroup(CreativeModeTab itemGroup) {
            return this.addToItemGroup(itemGroup, -1);
        }

        public CondensedItemEntry addToItemGroup(ResourceKey<CreativeModeTab> itemGroup) {
            return this.addToItemGroup(itemGroup, -1);
        }

        public CondensedItemEntry addToItemGroup(CreativeModeTab itemGroup, int tabIndex) {
            return this.addToItemGroup(ItemGroupHelper.of(itemGroup, tabIndex), true);
        }

        public CondensedItemEntry addToItemGroup(ResourceKey<CreativeModeTab> itemGroup, int tabIndex) {
            return this.addToItemGroup(ItemGroupHelper.of(itemGroup, tabIndex), true);
        }

        public List<CondensedItemEntry> addToItemGroups(CreativeModeTab ... groups) {
            return this.addToItemGroups(true, (ItemGroupHelper[])Arrays.stream(groups).map(group -> ItemGroupHelper.of(group, 0)).toArray(ItemGroupHelper[]::new));
        }

        @SafeVarargs
        public final List<CondensedItemEntry> addToItemGroups(ResourceKey<CreativeModeTab> ... groups) {
            return this.addToItemGroups(true, (ItemGroupHelper[])Arrays.stream(groups).map(group -> ItemGroupHelper.of((ResourceKey<CreativeModeTab>)group, 0)).toArray(ItemGroupHelper[]::new));
        }

        public List<CondensedItemEntry> addToItemGroups(boolean addToMainEntriesMap, ItemGroupHelper ... helpers) {
            ArrayList<CondensedItemEntry> condensedItemEntries = new ArrayList<CondensedItemEntry>();
            Builder builder = this;
            for (ItemGroupHelper helper : helpers) {
                condensedItemEntries.add(builder.addToItemGroup(helper, addToMainEntriesMap));
                builder = builder.copy();
            }
            return condensedItemEntries;
        }

        @ApiStatus.Internal
        public CondensedItemEntry addToItemGroup(ItemGroupHelper helper, boolean addToMainEntriesMap) {
            this.currentEntry.itemGroupInfo = helper;
            if (addToMainEntriesMap) {
                CondensedEntryRegistry.addCondensedEntryToRegistryMap(this.currentEntry, CondensedEntryRegistry.ENTRYPOINT_LOADED_ENTRIES);
            }
            return this.currentEntry;
        }

        public Builder copy() {
            return new Builder(this.currentEntry);
        }
    }
}

