/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import io.wispforest.condensed_creative.CondensedCreative;
import io.wispforest.condensed_creative.entry.impl.CondensedItemEntry;
import io.wispforest.condensed_creative.registry.CondensedEntryRegistry;
import io.wispforest.condensed_creative.util.ItemGroupHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class CondensedEntriesLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, CondensedItemEntry.Builder> LOCAL_ENTRIES = new HashMap<ResourceLocation, CondensedItemEntry.Builder>();
    private static boolean checkLocalEntries = false;
    private static final List<CreativeModeTab> BLACKLISTED_ITEM_GROUPS = Stream.of(CreativeModeTabs.f_256917_, CreativeModeTabs.f_256750_, CreativeModeTabs.f_256837_).map(arg_0 -> ((Registry)BuiltInRegistries.f_279662_).m_6246_(arg_0)).toList();

    public CondensedEntriesLoader() {
        super(GSON, "condensed_entries");
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        LOGGER.info("[CondensedEntriesLoader]: Starting loading!");
        if (!CondensedEntryRegistry.RESOURCE_LOADED_ENTRIES.isEmpty()) {
            CondensedEntryRegistry.RESOURCE_LOADED_ENTRIES.clear();
        }
        ArrayList ITEM_GROUPS = new ArrayList(CreativeModeTabs.m_257478_());
        ITEM_GROUPS.removeAll(BLACKLISTED_ITEM_GROUPS);
        prepared.forEach((id, jsonData) -> {
            try {
                CondensedEntriesLoader.deserializeFile(id, (JsonObject)jsonData, ITEM_GROUPS).forEach(condensedItemEntry -> CondensedEntryRegistry.addCondensedEntryToRegistryMap(condensedItemEntry, CondensedEntryRegistry.RESOURCE_LOADED_ENTRIES));
            }
            catch (JsonParseException | IllegalArgumentException var10) {
                LOGGER.error("[CondensedEntriesLoader]: Parsing error loading Condensed Entry {}", id, (Object)var10);
            }
        });
        LOGGER.info("[CondensedEntriesLoader]: Ending loading!");
    }

    private static List<CondensedItemEntry> deserializeFile(ResourceLocation id, JsonObject json, List<CreativeModeTab> itemGroups) {
        Map jsonMap = json.asMap();
        if (json.has("debug_entries")) {
            boolean debug_entries = GsonHelper.m_13912_((JsonObject)json, (String)"debug_entries");
            if (debug_entries && !CondensedCreative.isDeveloperMode()) {
                return List.of();
            }
            jsonMap.remove("debug_entries");
        }
        if (checkLocalEntries = json.has("sharded_entries")) {
            LOCAL_ENTRIES.clear();
            JsonObject entriesJson = json.getAsJsonObject("sharded_entries");
            for (Map.Entry entryJson : entriesJson.entrySet()) {
                ResourceLocation entryId = ResourceLocation.m_135820_((String)((String)entryJson.getKey()));
                if (entryId == null) {
                    LOGGER.error("[CondensedEntryLoader]: A given Condensed Entry has a invalid Identifier: [FileID: {}, EntryID: {}]", (Object)id, entryJson.getKey());
                }
                try {
                    LOCAL_ENTRIES.put(entryId, CondensedEntriesLoader.deserializeEntry(id, (String)entryJson.getKey(), (JsonElement)entryJson.getValue()).orElseThrow());
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            jsonMap.remove("sharded_entries");
        }
        ArrayList<CondensedItemEntry> entries = new ArrayList<CondensedItemEntry>();
        for (Map.Entry itemGroupEntries : jsonMap.entrySet()) {
            ResourceLocation itemGroupId = new ResourceLocation((String)itemGroupEntries.getKey());
            Optional<CreativeModeTab> itemGroup = itemGroups.stream().filter(group -> Objects.equals(BuiltInRegistries.f_279662_.m_7981_(group), itemGroupId)).findFirst();
            if (itemGroup.isEmpty()) {
                LOGGER.error("[CondensedEntryLoader]: A Invaild Itemgroup name was given so no Entries are loaded from it: [FileID: {}, GroupID: {}]", (Object)id, (Object)itemGroupId);
                continue;
            }
            Function<Integer, ItemGroupHelper> builder = integer -> new ItemGroupHelper((CreativeModeTab)itemGroup.get(), (int)integer);
            if (itemGroupEntries.getValue() instanceof JsonObject) {
                for (Map.Entry innerJson : ((JsonObject)itemGroupEntries.getValue()).entrySet()) {
                    String entryKey = (String)innerJson.getKey();
                    try {
                        int tabIndex = Integer.parseInt(entryKey);
                        if (!CondensedCreative.isOwoItemGroup.test(itemGroup.get())) {
                            LOGGER.error("[CondensedEntryLoader]: Tab Index's are only supported with OwoItemGroups: [FileID: {}, GroupID: {}]", (Object)id, (Object)itemGroupId);
                            continue;
                        }
                        int totalTabCount = CondensedCreative.getMaxTabCount.apply(itemGroup.get());
                        if (tabIndex > totalTabCount || tabIndex < 0) {
                            LOGGER.error("[CondensedEntryLoader]: The given Tab Index is out of the range for the given owoItemGroup: [FileID: {}, GroupID: {}, Tab: {}]", new Object[]{id, itemGroupId, tabIndex});
                            continue;
                        }
                        Object v = innerJson.getValue();
                        if (!(v instanceof JsonObject)) {
                            LOGGER.error("[CondensedEntryLoader]: It seems that the given tab was found to be malformed: [FileID: {}, GroupID: {}, Tab: {}]", new Object[]{id, itemGroupId, entryKey});
                            continue;
                        }
                        JsonObject innerJsonObject = (JsonObject)v;
                        innerJsonObject.asMap().forEach((s, element) -> {
                            try {
                                entries.add(CondensedEntriesLoader.deserializeEntry(id, s, element).orElseThrow().addToItemGroup((ItemGroupHelper)builder.apply(tabIndex), false));
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                // empty catch block
                            }
                        });
                    }
                    catch (NumberFormatException ignored) {
                        try {
                            entries.add(CondensedEntriesLoader.deserializeEntry(id, (String)innerJson.getKey(), (JsonElement)innerJson.getValue()).orElseThrow().addToItemGroup(builder.apply(0), false));
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                }
                continue;
            }
            LOGGER.error("[CondensedEntryLoader]: The Json File is malformed in the a certain ItemGroup section: [FileID: {}, Name: {}]", (Object)id, (Object)itemGroupId);
        }
        return entries;
    }

    private static Optional<CondensedItemEntry.Builder> deserializeEntry(ResourceLocation fileID, String key, JsonElement jsonData) {
        MutableComponent text;
        JsonElement element;
        CondensedItemEntry.Builder builder;
        if (!(jsonData instanceof JsonObject)) {
            LOGGER.error("[CondensedEntryLoader]: A given Entry was attempted to be read but was malformed: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
            return Optional.empty();
        }
        JsonObject jsonObject = (JsonObject)jsonData;
        ResourceLocation entryId = ResourceLocation.m_135820_((String)key);
        if (entryId == null) {
            LOGGER.error("[CondensedEntryLoader]: A given Condensed Entry has a invalid Identifier: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
            return Optional.empty();
        }
        if (checkLocalEntries && LOCAL_ENTRIES.containsKey(entryId)) {
            builder = LOCAL_ENTRIES.get(entryId).copy();
        } else {
            Item item;
            try {
                item = GsonHelper.m_13909_((JsonObject)jsonObject, (String)"base_item");
            }
            catch (JsonSyntaxException e) {
                LOGGER.warn("[CondensedEntryLoader]: The Base Item for a given entry was found to be malformed in some way: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
                LOGGER.warn(e.getMessage());
                return Optional.empty();
            }
            if (jsonObject.has("item_tag")) {
                itemTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item_tag")));
                builder = CondensedEntryRegistry.fromTag(entryId, (ItemLike)item, itemTagKey);
            } else if (jsonObject.has("block_tag")) {
                itemTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block_tag")));
                builder = CondensedEntryRegistry.fromTag(entryId, (ItemLike)item, itemTagKey);
            } else if (jsonObject.has("items")) {
                ArrayList items = new ArrayList();
                GsonHelper.m_13933_((JsonObject)jsonObject, (String)"items").forEach(jsonElement -> items.add(GsonHelper.m_13874_((JsonElement)jsonElement, (String)jsonElement.getAsString())));
                builder = CondensedEntryRegistry.fromItems(entryId, (ItemLike)item, items);
            } else {
                LOGGER.error("[CondensedEntryLoader]: A Entry seems to be missing the needed info to create it self within its JSON: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
                return Optional.empty();
            }
        }
        if (jsonObject.has("strict_filter")) {
            JsonPrimitive primitive;
            element = jsonObject.get("strict_filter");
            if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isBoolean()) {
                builder.toggleStrictFiltering(primitive.getAsBoolean());
            } else {
                LOGGER.warn("[CondensedEntryLoader]: Strict Filter Mode wasn't found to be a boolean: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
            }
        }
        if (jsonObject.has("title")) {
            element = jsonObject.get("title");
            try {
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().getAsString().equals("USE_TAG")) {
                    if (builder.currentEntry.getTagKey() != null) {
                        builder.setTitleFromTag();
                    }
                } else {
                    text = Component.Serializer.m_130691_((JsonElement)element);
                    builder.setTitle((Component)text);
                }
            }
            catch (JsonParseException e) {
                LOGGER.warn("[CondensedEntryLoader]: The Title for a given Entry threw a error during reading: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
                LOGGER.warn(e.getMessage());
            }
        }
        if (jsonObject.has("description")) {
            element = jsonObject.get("description");
            try {
                text = Component.Serializer.m_130691_((JsonElement)element);
                builder.setDescription((Component)text);
            }
            catch (JsonParseException e) {
                LOGGER.warn("[CondensedEntryLoader]: The Description for a given Entry threw a error during reading: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
                LOGGER.warn(e.getMessage());
            }
        }
        if (jsonObject.has("entry_order")) {
            element = jsonObject.get("entry_order");
            if (element.isJsonPrimitive()) {
                String string = element.getAsString();
                if (Objects.equals(string, "ITEMGROUP")) {
                    builder.setEntryOrder(CondensedItemEntry.EntryOrder.ITEMGROUP_ORDER);
                } else if (Objects.equals(string, "DEFAULT")) {
                    builder.setEntryOrder(CondensedItemEntry.EntryOrder.DEFAULT_ORDER);
                } else {
                    LOGGER.warn("[CondensedEntryLoader]: A given Entry Order seems to not exist with the list of Orderings: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
                }
            } else {
                LOGGER.warn("[CondensedEntryLoader]: A given Entry Order was found to be malformed in some way: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
            }
        }
        if (jsonObject.has("item_comparison")) {
            element = jsonObject.get("item_comparison");
            if (element.isJsonPrimitive()) {
                boolean value = element.getAsBoolean();
                builder.useItemComparison(value);
            } else {
                LOGGER.warn("[CondensedEntryLoader]: A Item Comparison was found to be malformed in some way: [FileID: {}, EntryID: {}]", (Object)fileID, (Object)key);
            }
        }
        return Optional.of(builder);
    }
}

