/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.condensed_creative.data;

import com.mojang.logging.LogUtils;
import io.wispforest.condensed_creative.CondensedCreative;
import io.wispforest.condensed_creative.compat.CondensedCreativeConfig;
import io.wispforest.condensed_creative.compat.EntryTypeCondensing;
import io.wispforest.condensed_creative.entry.impl.CondensedItemEntry;
import io.wispforest.condensed_creative.registry.CondensedEntryRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class BuiltinEntries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Function<String, String>> WOOD_BLOCK_TYPES = List.of(woodType -> "*_" + (woodType.equals("crimson") || woodType.equals("warped") ? "stem" : "log"), woodType -> "*_" + (woodType.equals("crimson") || woodType.equals("warped") ? "hyphae" : "wood"), woodType -> "stripped_*_" + (woodType.equals("crimson") || woodType.equals("warped") ? "stem" : "log"), woodType -> "stripped_*_" + (woodType.equals("crimson") || woodType.equals("warped") ? "hyphae" : "wood"), woodType -> "*_planks", woodType -> "*_stairs", woodType -> "*_slab", woodType -> "*_fence", woodType -> "*_fence_gate", woodType -> "*_door", woodType -> "*_trapdoor", woodType -> "*_pressure_plate", woodType -> "*_button");
    private static final List<MobCategory> creatures = List.of(MobCategory.CREATURE, MobCategory.AXOLOTLS, MobCategory.AMBIENT, MobCategory.WATER_CREATURE, MobCategory.WATER_AMBIENT, MobCategory.UNDERGROUND_WATER_CREATURE);
    private static final Predicate<Item> vanillaItemsOnly = item -> Objects.equals(BuiltInRegistries.f_257033_.m_7981_(item).m_135827_(), "minecraft");

    public static void registerBuiltinEntries() {
        WoodType.m_61843_().forEach(signType -> {
            ResourceLocation identifier = new ResourceLocation(signType.f_61839_());
            ArrayList<ItemStack> woodItemStacks = new ArrayList<ItemStack>();
            WOOD_BLOCK_TYPES.forEach(blockType -> {
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(identifier.m_135827_(), ((String)blockType.apply(identifier.m_135815_())).replace("*", identifier.m_135815_())));
                if (item != Items.f_41852_) {
                    woodItemStacks.add(item.m_7968_());
                }
            });
            if (woodItemStacks.isEmpty()) {
                LOGGER.warn("[CondensedCreative]: Attempted to create a builtin entry for the given WoodType [WoodType: {}, BlockSetType: {}] but was unable to find the registry entries!", (Object)signType.f_61839_(), (Object)signType.f_271340_().f_271253_());
                return;
            }
            if (signType == WoodType.f_244200_) {
                woodItemStacks.add(0, Items.f_256933_.m_7968_());
                woodItemStacks.add(1, Items.f_256923_.m_7968_());
                woodItemStacks.add(5, Items.f_243813_.m_7968_());
                woodItemStacks.add(6, Items.f_243828_.m_7968_());
                woodItemStacks.add(7, Items.f_244160_.m_7968_());
            }
            CondensedEntryRegistry.fromItemStacks(identifier, (ItemStack)woodItemStacks.get(0), woodItemStacks).toggleStrictFiltering(true).setEntryOrder(CondensedItemEntry.EntryOrder.ITEMGROUP_ORDER).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
        });
        Map<String, Item> stoneTypes = Map.ofEntries(Map.entry("stone", Items.f_41905_), Map.entry("granite", Items.f_41958_), Map.entry("diorite", Items.f_42064_), Map.entry("andesite", Items.f_42170_), Map.entry("sandstone", Items.f_41856_), Map.entry("prismarine", Items.f_42192_), Map.entry("deepslate", Items.f_151034_), Map.entry("blackstone", Items.f_42755_), Map.entry("end_stone", Items.f_42102_), Map.entry("quartz", Items.f_42157_), Map.entry("copper", Items.f_151000_));
        stoneTypes.forEach((stoneType, startingItem) -> {
            ResourceLocation identifier = new ResourceLocation(stoneType);
            ArrayList<ItemStack> stoneItemStacks = new ArrayList<ItemStack>();
            BuiltInRegistries.f_256975_.m_6566_().forEach(identifier1 -> {
                List<String> listOfMatches;
                String blockPath = identifier1.m_135815_();
                if (identifier1.m_135827_().equals("minecraft") && blockPath.contains((CharSequence)stoneType) && (listOfMatches = stoneTypes.keySet().stream().filter(stoneType1 -> blockPath.contains((CharSequence)stoneType1) && !stoneType1.equals(stoneType) && stoneType1.contains((CharSequence)stoneType)).toList()).isEmpty()) {
                    stoneItemStacks.add(((Item)BuiltInRegistries.f_257033_.m_7745_(identifier1)).m_7968_());
                }
            });
            if (!stoneItemStacks.isEmpty()) {
                CondensedEntryRegistry.fromItemStacks(identifier, (ItemLike)startingItem, stoneItemStacks).toggleStrictFiltering(true).setEntryOrder(CondensedItemEntry.EntryOrder.ITEMGROUP_ORDER).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
            } else {
                LOGGER.warn("The given material Type [{}] seems to have not matched anything!", stoneType);
            }
        });
        CondensedEntryRegistry.of(CondensedCreative.createID("signs"), (ItemLike)Items.f_42438_, item -> BuiltinEntries.fromTags(item, ItemTags.f_13157_, ItemTags.f_244389_)).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.of(CondensedCreative.createID("infested_blocks"), (ItemLike)Items.f_42438_, item -> {
            BlockItem bi;
            return item instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof InfestedBlock;
        }).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.ofSupplier(CondensedCreative.createID("paintings"), (ItemLike)Items.f_42487_, () -> {
            ArrayList paintingVariantStacks = new ArrayList();
            BuiltInRegistries.f_257051_.m_203611_().filter(pv -> pv.m_203656_(PaintingVariantTags.f_215870_)).sorted(Comparator.comparing(Holder::m_203334_, Comparator.comparingInt(pv -> pv.m_218909_() * pv.m_218908_()).thenComparing(PaintingVariant::m_218908_))).forEach(paintingVariant -> {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42487_);
                Painting.m_269220_((CompoundTag)itemStack.m_41698_("EntityTag"), (Holder)paintingVariant);
                paintingVariantStacks.add(itemStack);
            });
            return paintingVariantStacks;
        }).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("wools"), (ItemLike)Blocks.f_50041_, ItemTags.f_13167_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("terracotta"), (ItemLike)Blocks.f_50352_, ItemTags.f_198161_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.of(CondensedCreative.createID("concrete"), (ItemLike)Blocks.f_50542_, item -> {
            if (item instanceof BlockItem) {
                String itemPath = BuiltInRegistries.f_257033_.m_7981_(item).m_135815_();
                return itemPath.contains("concrete") && !itemPath.contains("powder");
            }
            return false;
        }).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.of(CondensedCreative.createID("concrete_powder"), (ItemLike)Blocks.f_50506_, item -> {
            if (item instanceof BlockItem) {
                String itemPath = BuiltInRegistries.f_257033_.m_7981_(item).m_135815_();
                return itemPath.contains("concrete") && itemPath.contains("powder");
            }
            return false;
        }).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.fromItems(CondensedCreative.createID("ores"), (ItemLike)Blocks.f_49996_, Stream.of(Blocks.f_49997_, Blocks.f_152469_, Blocks.f_49996_, Blocks.f_152468_, Blocks.f_152505_, Blocks.f_152506_, Blocks.f_49995_, Blocks.f_152467_, Blocks.f_50173_, Blocks.f_152473_, Blocks.f_50264_, Blocks.f_152479_, Blocks.f_50059_, Blocks.f_152472_, Blocks.f_50089_, Blocks.f_152474_, Blocks.f_49998_, Blocks.f_50331_).map(Block::m_5456_).toList()).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_);
        CondensedEntryRegistry.of(CondensedCreative.createID("glass"), (ItemLike)Blocks.f_50147_, item -> {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof StainedGlassBlock;
        }).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("carpets"), (ItemLike)Blocks.f_50336_, ItemTags.f_215867_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("candles"), (ItemLike)Blocks.f_152483_, ItemTags.f_144319_).toggleStrictFiltering(true).addToItemGroups(CreativeModeTabs.f_256725_, CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("beds"), (ItemLike)Blocks.f_50066_, ItemTags.f_13146_).toggleStrictFiltering(true).addToItemGroups(CreativeModeTabs.f_256725_, CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("banners"), (ItemLike)Blocks.f_50414_, ItemTags.f_13191_).toggleStrictFiltering(true).addToItemGroups(CreativeModeTabs.f_256725_, CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.of(CondensedCreative.createID("stained_glass_panes"), (ItemLike)Blocks.f_50185_, BuiltinEntries.predicateWithVanillaCheck(item -> {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof StainedGlassPaneBlock;
        })).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.of(CondensedCreative.createID("corals"), (ItemLike)Blocks.f_50595_, BuiltinEntries.predicateWithVanillaCheck(item -> {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof BaseCoralPlantTypeBlock;
        })).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_);
        CondensedEntryRegistry.of(CondensedCreative.createID("glazed_terracotta"), (ItemLike)Blocks.f_50526_, BuiltinEntries.predicateWithVanillaCheck(item -> {
            BlockItem blockItem;
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof GlazedTerracottaBlock;
        })).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("shulkers"), (ItemLike)Blocks.f_50456_, BlockTags.f_13083_).toggleStrictFiltering(true).addToItemGroups(CreativeModeTabs.f_256725_, CreativeModeTabs.f_256791_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("buttons"), (ItemLike)Blocks.f_50124_, ItemTags.f_13171_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("pressure_plates"), (ItemLike)Blocks.f_50165_, BlockTags.f_13099_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("doors"), (ItemLike)Blocks.f_50166_, BlockTags.f_13103_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("trapdoors"), (ItemLike)Blocks.f_50376_, BlockTags.f_13036_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("fence_gates"), (ItemLike)Blocks.f_50192_, BlockTags.f_13055_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        CondensedEntryRegistry.of(CondensedCreative.createID(MobCategory.CREATURE.toString().toLowerCase()), (ItemLike)Items.f_42548_, BuiltinEntries.isSpawnEggItem(spawnEggItem -> creatures.contains(spawnEggItem.m_43228_(null).m_20674_()))).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_);
        CondensedEntryRegistry.of(CondensedCreative.createID(MobCategory.MONSTER.toString().toLowerCase()), (ItemLike)Items.f_42608_, BuiltinEntries.isSpawnEggItem(spawnEggItem -> spawnEggItem.m_43228_(null).m_20674_() == MobCategory.MONSTER)).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_);
        CondensedEntryRegistry.of(CondensedCreative.createID(MobCategory.MISC.toString().toLowerCase()), (ItemLike)Items.f_42601_, BuiltinEntries.isSpawnEggItem(spawnEggItem -> spawnEggItem.m_43228_(null).m_20674_() == MobCategory.MISC)).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("music_discs"), (ItemLike)Items.f_42752_, ItemTags.f_13158_).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_);
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("boats"), (ItemLike)Items.f_42453_, ItemTags.f_13155_).toggleStrictFiltering(true).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_);
        CreativeModeTab combat = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256797_);
        BuiltinEntries.addPotionBasedEntries(Items.f_42738_, combat, 0, "Arrows", ((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).defaultEntriesConfig.tippedArrows);
        EntryTypeCondensing potion = ((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).defaultEntriesConfig.potions;
        Set stacks = ItemStackLinkedSet.m_261170_();
        for (SuspiciousEffectHolder susStewIngr : SuspiciousEffectHolder.m_257904_()) {
            stacks.add((ItemStack)Util.m_137469_((Object)new ItemStack((ItemLike)Items.f_42718_), stack -> SuspiciousStewItem.m_43258_((ItemStack)stack, (MobEffect)susStewIngr.m_53521_(), (int)susStewIngr.m_53522_())));
        }
        CondensedEntryRegistry.fromItemStacks(CondensedCreative.createID("suspicious_stews"), (ItemStack)stacks.iterator().next(), (Collection<ItemStack>)stacks).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256839_);
        CreativeModeTab foodAndDrink = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256839_);
        BuiltinEntries.addPotionBasedEntries(Items.f_42589_, foodAndDrink, 0, "Potions", potion);
        BuiltinEntries.addPotionBasedEntries(Items.f_42736_, foodAndDrink, 1, "Potions", potion);
        BuiltinEntries.addPotionBasedEntries(Items.f_42739_, foodAndDrink, 1, "Potions", potion);
        CondensedEntryRegistry.fromItems(CondensedCreative.createID("dyes"), (ItemLike)Items.f_42535_, Arrays.stream(DyeColor.values()).map(dyeColor -> (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeColor.m_41065_() + "_dye"))).filter(item -> item != Items.f_41852_).toList()).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
        BuiltinEntries.addEnchantmentEntries();
        CondensedEntryRegistry.fromTag(CondensedCreative.createID("pottery_sherds"), (ItemLike)Items.f_279633_, ItemTags.f_271220_).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
        CondensedEntryRegistry.of(CondensedCreative.createID("templates"), (ItemLike)Items.f_265918_, i -> i instanceof SmithingTemplateItem).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
    }

    private static void addEnchantmentEntries() {
        EntryTypeCondensing entryTypeCondensing = ((CondensedCreativeConfig)CondensedCreative.MAIN_CONFIG.getConfig()).defaultEntriesConfig.enchantmentBooks;
        if (entryTypeCondensing == EntryTypeCondensing.NONE) {
            return;
        }
        EnumSet<EnchantmentCategory> targets = EnumSet.allOf(EnchantmentCategory.class);
        ArrayList<ItemStack> allEnchantmentBooks = new ArrayList<ItemStack>();
        for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            if (!targets.contains(enchantment.f_44672_)) continue;
            ArrayList<ItemStack> enchantmentBooks = new ArrayList<ItemStack>();
            for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
                enchantmentBooks.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
            }
            if (entryTypeCondensing == EntryTypeCondensing.SEPARATE_COLLECTIONS) {
                MutableComponent mutableText = Component.m_237115_((String)enchantment.m_44704_());
                mutableText.m_130940_(ChatFormatting.WHITE);
                CondensedEntryRegistry.fromItemStacks(CondensedCreative.createID(enchantment.m_44704_()), (ItemStack)enchantmentBooks.get(0), enchantmentBooks).setTitle((Component)mutableText).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
                continue;
            }
            allEnchantmentBooks.addAll(enchantmentBooks);
        }
        if (!allEnchantmentBooks.isEmpty()) {
            CondensedEntryRegistry.fromItemStacks(CondensedCreative.createID("enchantment_books"), (ItemLike)Items.f_42690_, allEnchantmentBooks).addToItemGroup((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
        }
    }

    private static void addPotionBasedEntries(Item potionBasedItem, CreativeModeTab targetGroup, int wordIndex, String pluralizedWord, EntryTypeCondensing entryTypeCondensing) {
        if (entryTypeCondensing == EntryTypeCondensing.NONE) {
            return;
        }
        LinkedHashMap<List, List> sortedPotions = new LinkedHashMap<List, List>();
        for (Potion potion : BuiltInRegistries.f_256980_) {
            if (potion == Potions.f_43598_) continue;
            List<MobEffect> effects = potion.m_43488_().stream().map(MobEffectInstance::m_19544_).toList();
            sortedPotions.computeIfAbsent(effects, statusEffects -> new ArrayList()).add(potion);
        }
        ArrayList<ItemStack> allPotionItems = new ArrayList<ItemStack>();
        sortedPotions.forEach((statusEffects, potions) -> {
            ArrayList<ItemStack> potionItems = new ArrayList<ItemStack>();
            potions.forEach(p -> potionItems.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)potionBasedItem), (Potion)p)));
            if (potionItems.isEmpty()) {
                return;
            }
            if (entryTypeCondensing == EntryTypeCondensing.SEPARATE_COLLECTIONS) {
                String translationKey = ((ItemStack)potionItems.get(0)).m_41778_();
                CondensedEntryRegistry.fromItemStacks(CondensedCreative.createID(translationKey), (ItemStack)potionItems.get(0), potionItems).setTitleSupplier(() -> {
                    Object[] words = Component.m_237115_((String)translationKey).getString().split(" ");
                    words[wordIndex] = pluralizedWord;
                    return Component.m_237113_((String)StringUtils.join((Object[])words, (String)" ")).m_130940_(ChatFormatting.WHITE);
                }).addToItemGroup(targetGroup);
            } else {
                allPotionItems.addAll(potionItems);
            }
        });
        if (!allPotionItems.isEmpty()) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)potionBasedItem);
            Object[] words = itemId.m_135815_().split("_");
            words[words.length - 1] = pluralizedWord.toLowerCase();
            String path = StringUtils.join((Object[])words, (String)"_");
            CondensedEntryRegistry.fromItemStacks(CondensedCreative.createID(path), (ItemLike)potionBasedItem, allPotionItems).addToItemGroup(targetGroup);
        }
    }

    private static Predicate<Item> predicateWithVanillaCheck(Predicate<Item> mainPredicate) {
        return item -> vanillaItemsOnly.and(mainPredicate).test((Item)item);
    }

    private static Predicate<Item> isSpawnEggItem(Predicate<SpawnEggItem> predicate) {
        return item -> {
            SpawnEggItem spawnEggItem;
            return item instanceof SpawnEggItem && predicate.test(spawnEggItem = (SpawnEggItem)item);
        };
    }

    @SafeVarargs
    private static <T extends ItemLike> boolean fromTags(Item item, TagKey<T> ... tagKeys) {
        if (tagKeys.length == 0) {
            return false;
        }
        boolean isInTag = false;
        for (TagKey<T> tagKey : tagKeys) {
            if (tagKey.m_207645_(Registries.f_256913_)) {
                isInTag = item.m_204114_().m_203656_(tagKey);
            } else if (tagKey.m_207645_(Registries.f_256747_)) {
                BlockItem blockItem;
                isInTag = item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_204297_().m_203656_(tagKey);
            } else {
                LOGGER.warn("It seems that a Condensed Entry was somehow registered with Tag that isn't part of the Item or Block Registry");
            }
            if (!isInTag) continue;
            return true;
        }
        return isInTag;
    }
}

