/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwner;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.helper.HorseHelper;

public class OwnerSyncShowStatsPacket {
    private CompoundTag ownerNBT = null;

    public OwnerSyncShowStatsPacket() {
    }

    public OwnerSyncShowStatsPacket(IHorseOwner owner) {
        this.ownerNBT = HorseOwner.writeNBT(owner);
    }

    public OwnerSyncShowStatsPacket(FriendlyByteBuf buf) {
        this.ownerNBT = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.ownerNBT);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Player player;
            if (ctx.getDirection().getReceptionSide().isClient() && (player = CallableHorses.proxy.getPlayer()) != null) {
                IHorseOwner owner = HorseHelper.getOwnerCap(player);
                HorseOwner.readNBT(owner, this.ownerNBT);
                CallableHorses.proxy.displayStatViewer();
            }
        });
        ctx.setPacketHandled(true);
    }
}

