/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.capabilities.storedhorse;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tschipp.callablehorses.common.capabilities.CapabilityHandler;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;

public class StoredHorse
implements IStoredHorse,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    private String storageUUID = "";
    private String ownerUUID = "";
    private int horseNum = 0;
    private boolean owned = false;

    @Override
    public String getStorageUUID() {
        return this.storageUUID;
    }

    @Override
    public void setStorageUUID(String uuid) {
        this.storageUUID = uuid;
    }

    @Override
    public String getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public void setHorseNum(int num) {
        this.horseNum = num;
    }

    @Override
    public int getHorseNum() {
        return this.horseNum;
    }

    @Override
    public void setOwned(boolean bool) {
        this.owned = bool;
    }

    @Override
    public boolean isOwned() {
        return this.owned;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.HORSE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        return StoredHorse.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag tag) {
        StoredHorse.readNBT(this, tag);
    }

    public static CompoundTag writeNBT(IStoredHorse instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("owner", instance.getOwnerUUID());
        tag.m_128405_("horseNum", instance.getHorseNum());
        tag.m_128359_("storage", instance.getStorageUUID());
        tag.m_128379_("owned", instance.isOwned());
        return tag;
    }

    public static void readNBT(IStoredHorse instance, CompoundTag tag) {
        instance.setOwnerUUID(tag.m_128461_("owner"));
        instance.setHorseNum(tag.m_128451_("horseNum"));
        instance.setStorageUUID(tag.m_128461_("storage"));
        instance.setOwned(tag.m_128471_("owned"));
    }
}

