/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.entity.living;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class MobSpawnEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public MobSpawnEventListener(IEventBus forgeEventBus, EntityTypeRegistry entityTypeRegistry) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onMobSpawn);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    private void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        IronGolem ironGolem;
        if (event.getEntity().m_6095_() == EntityType.f_20460_ && (ironGolem = (IronGolem)event.getEntity()).m_217043_().m_188502_() % 256 == 1) {
            IronGolem newMob;
            ServerLevelAccessor level = event.getLevel();
            EntityType entityType = (EntityType)this.entityTypeRegistry.getButterflyGolem().get();
            if (ForgeEventFactory.canLivingConvert((LivingEntity)ironGolem, (EntityType)entityType, x -> {}) && (newMob = (IronGolem)ironGolem.m_21406_(entityType, false)) != null) {
                newMob.m_6518_(level, level.m_6436_(newMob.m_20183_()), MobSpawnType.CONVERSION, null, null);
                ForgeEventFactory.onLivingConvert((LivingEntity)ironGolem, (LivingEntity)newMob);
                if (!newMob.m_20067_()) {
                    level.m_5898_(null, 1026, newMob.m_20183_(), 0);
                }
            }
        }
    }
}

