/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.better_creative_tabs.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class BCTConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static void init() {
        BCTConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }

    private static void register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "l2_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<String>> priorityModTabs;

        Client(ForgeConfigSpec.Builder builder) {
            this.priorityModTabs = builder.comment("List of mod id for which tab will appear first.").comment(" If you add a library mod without tab here, dependencies of the library mods will be grouped together").define("priorityModTabs", new ArrayList<String>(List.of("l2library", "farmersdelight")));
        }
    }
}

