/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.better_creative_tabs.creative;

import dev.xkmc.better_creative_tabs.creative.CreativeTabGroup;
import dev.xkmc.better_creative_tabs.init.BCTConfig;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class DependencySorter {
    public static List<CreativeTabGroup> init() {
        List config = (List)BCTConfig.CLIENT.priorityModTabs.get();
        LinkedHashSet forced = new LinkedHashSet(config);
        LinkedHashMap<String, Object> mods = new LinkedHashMap<String, Object>();
        mods.put("minecraft", new Entry(null));
        for (String c : config) {
            ModList.get().getModContainerById(c).ifPresent(e -> mods.put(c, new Entry((ModContainer)e)));
        }
        ArrayList<CreativeModeTab> missing = new ArrayList<CreativeModeTab>();
        ArrayList raw = new ArrayList(CreativeModeTabRegistry.getSortedCreativeModeTabs());
        List<Pair> sorted = raw.stream().map(e -> Pair.of((Object)BuiltInRegistries.f_279662_.m_7981_(e), (Object)e)).sorted(Comparator.comparing(e -> ((ResourceLocation)e.first()).m_135827_())).toList();
        for (Pair pair : sorted) {
            String id = ((ResourceLocation)pair.first()).m_135827_();
            Object mod = (Entry)mods.get(id);
            if (mod == null) {
                Optional cont = ModList.get().getModContainerById(id);
                if (cont.isEmpty()) {
                    missing.add((CreativeModeTab)pair.second());
                    continue;
                }
                mod = new Entry((ModContainer)cont.get());
                mods.put(id, mod);
            }
            ((Entry)mod).tabs.add((CreativeModeTab)pair.second());
        }
        LinkedHashSet modSet = new LinkedHashSet(mods.values());
        for (Entry e2 : modSet) {
            if (e2.mod == null) continue;
            for (IModInfo.ModVersion dep : e2.mod.getModInfo().getDependencies()) {
                Object par;
                if (!dep.isMandatory() || (par = (Entry)mods.get(dep.getModId())) == null || ((Entry)par).mod == null || !forced.contains(((Entry)par).mod.getModId()) && ((Entry)par).tabs.isEmpty()) continue;
                ((Entry)par).testDeps.add(e2);
                e2.testParents.add((Entry)par);
            }
        }
        for (Entry e2 : modSet) {
            Entry par = null;
            int max = 0;
            for (Entry p : e2.testParents) {
                if (p.testDeps.size() <= max) continue;
                max = p.testDeps.size();
                par = p;
            }
            if (par == null) continue;
            e2.parent = par;
            par.dep.add(e2);
        }
        modSet.removeIf(e -> e.parent != null);
        ArrayList<CreativeTabGroup> arrayList = new ArrayList<CreativeTabGroup>();
        CreativeTabGroup other = new CreativeTabGroup();
        for (Entry e3 : modSet) {
            if (!e3.dep.isEmpty() || e3.tabs.size() > 1) {
                CreativeTabGroup group = new CreativeTabGroup();
                e3.addAll(group);
                arrayList.add(group);
                continue;
            }
            other.tabs.addAll(e3.tabs);
        }
        other.tabs.addAll(missing);
        arrayList.add(other);
        return arrayList;
    }

    private static final class Entry {
        @Nullable
        private final ModContainer mod;
        private final List<Entry> testDeps = new ArrayList<Entry>();
        private final List<Entry> testParents = new ArrayList<Entry>();
        private final List<CreativeModeTab> tabs = new ArrayList<CreativeModeTab>();
        private Entry parent;
        private final List<Entry> dep = new ArrayList<Entry>();

        private Entry(@Nullable ModContainer mod) {
            this.mod = mod;
        }

        public void addAll(CreativeTabGroup group) {
            group.tabs.addAll(this.tabs);
            for (Entry e : this.dep) {
                e.addAll(group);
            }
        }
    }
}

