/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.better_creative_tabs.creative;

import dev.xkmc.better_creative_tabs.creative.CreativeIndexLayout;
import dev.xkmc.better_creative_tabs.creative.CreativeTabList;
import dev.xkmc.better_creative_tabs.mixin.CreativeModeInventoryScreenAccessor;
import dev.xkmc.better_creative_tabs.util.MenuLayoutConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.CreativeTabsScreenPage;

public class CreativeIndexScreen
extends Screen {
    private static final MenuLayoutConfig MANAGER = CreativeIndexLayout.get();
    private static final Component TITLE = Component.m_237115_((String)"better-creative-tabs.creative_index");
    private static final int MAX = 81;
    private final List<CreativeModeTab> allTabs = CreativeTabList.getTabs();
    private final MenuLayoutConfig manager;
    private final String[] slots;
    private int page;
    private String initialText;
    private List<CreativeModeTab> tabs = new ArrayList<CreativeModeTab>(this.allTabs);
    private EditBox editBox;
    private boolean completeInit = false;
    private int imageWidth;
    private int imageHeight;
    private int leftPos;
    private int topPos;
    private CreativeModeTab hovered = null;

    public CreativeIndexScreen(int page) {
        this(page, "");
    }

    public CreativeIndexScreen(int page, String text) {
        this(TITLE, MANAGER, page, text, "grid");
    }

    protected CreativeIndexScreen(Component title, MenuLayoutConfig manager, int page, String text, String ... slots) {
        super(title);
        this.page = page;
        this.manager = manager;
        this.slots = slots;
        this.initialText = text;
    }

    protected void m_7856_() {
        this.completeInit = false;
        this.imageWidth = 176;
        this.imageHeight = this.manager.getHeight();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.editBox == null) {
            this.editBox = new EditBox(this.f_96547_, this.leftPos + 8, this.topPos + 19, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
            this.editBox.m_94144_(this.initialText);
            this.editBox.m_94199_(50);
            this.editBox.m_94182_(true);
            this.editBox.m_94194_(true);
            this.editBox.m_94202_(0xFFFFFF);
        }
        this.m_142416_((GuiEventListener)this.editBox);
        this.rebuildTabList();
        int totalPage = (this.tabs.size() - 1) / 81 + 1;
        int x = (this.f_96543_ + this.imageWidth) / 2 - 16;
        int y = (this.f_96544_ - this.imageHeight) / 2 + 4;
        int w = 10;
        int h = 11;
        this.page = Math.min(totalPage - 1, Math.max(0, this.page));
        if (this.page > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), e -> this.click(-1)).m_252794_(x - w - 1, y).m_253046_(w, h).m_253136_());
        }
        if (this.page < totalPage - 1) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), e -> this.click(1)).m_252794_(x, y).m_253046_(w, h).m_253136_());
        }
        this.completeInit = true;
    }

    private void rebuildTabList() {
        String val = this.editBox.m_94155_().toLowerCase(Locale.ROOT);
        int oldPage = (this.tabs.size() - 1) / 81 + 1;
        this.tabs = this.allTabs.stream().filter(e -> e.m_40786_().getString().toLowerCase(Locale.ROOT).contains(val) || BuiltInRegistries.f_279662_.m_7981_(e).toString().contains(val)).toList();
        int newPage = (this.tabs.size() - 1) / 81 + 1;
        if (this.completeInit && (this.page > 0 || newPage != oldPage)) {
            this.page = 0;
            this.reinit();
        }
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        this.initialText = this.editBox.m_94155_();
        boolean isFocused = this.editBox.m_93696_();
        super.m_6574_(mc, x, y);
        if (isFocused) {
            this.m_7522_((GuiEventListener)this.editBox);
        }
    }

    private void reinit() {
        this.initialText = this.editBox.m_94155_();
        boolean isFocused = this.editBox.m_93696_();
        this.m_7856_();
        if (isFocused) {
            this.m_7522_((GuiEventListener)this.editBox);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.editBox.m_94120_();
    }

    public boolean m_5534_(char key, int mod) {
        if (!this.editBox.m_93696_()) {
            return false;
        }
        String s = this.editBox.m_94155_();
        if (this.editBox.m_5534_(key, mod)) {
            if (!Objects.equals(s, this.editBox.m_94155_())) {
                this.rebuildTabList();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int key, int mod, int scan) {
        String s = this.editBox.m_94155_();
        if (this.editBox.m_7933_(key, mod, scan)) {
            if (!Objects.equals(s, this.editBox.m_94155_())) {
                this.rebuildTabList();
            }
            return true;
        }
        if (this.editBox.m_93696_() && this.editBox.m_94213_()) {
            if (key == 256) {
                this.editBox.m_93692_(false);
            }
            return true;
        }
        return super.m_7933_(key, mod, scan);
    }

    private void click(int btn) {
        this.page += btn;
        this.reinit();
    }

    protected void renderLabels(GuiGraphics g, int mx, int my) {
        int maxPage = (this.tabs.size() - 1) / 81 + 1;
        String count = " (" + (this.page + 1) + "/" + maxPage + ")";
        g.m_280614_(this.f_96547_, (Component)TITLE.m_6881_().m_130946_(count), 8, 6, 0x404040, false);
    }

    @Nullable
    protected CreativeModeTab getStack(String comp, int x, int y) {
        int ind = x + y * 9 + this.page * 81;
        if (ind >= this.tabs.size()) {
            return null;
        }
        return this.tabs.get(ind);
    }

    protected void renderTooltip(GuiGraphics g, Font font, CreativeModeTab hovered, int mx, int my) {
        g.m_280677_(font, List.of(hovered.m_40786_(), Component.m_237113_((String)BuiltInRegistries.f_279662_.m_7981_((Object)hovered).toString()).m_130940_(ChatFormatting.DARK_GRAY)), Optional.empty(), mx, my);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (super.m_6348_(mx, my, button)) {
            return true;
        }
        SlotResult result = this.findSlot(mx, my);
        if (result == null) {
            return false;
        }
        int ind = result.x() + result.y() * 9 + this.page * 81;
        if (ind >= this.tabs.size()) {
            return false;
        }
        CreativeModeInventoryScreen screen = new CreativeModeInventoryScreen((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.f_108617_.m_247016_(), ((Boolean)this.f_96541_.f_91066_.m_257871_().m_231551_()).booleanValue());
        Minecraft.m_91087_().m_91152_((Screen)screen);
        CreativeModeInventoryScreenAccessor scr = (CreativeModeInventoryScreenAccessor)screen;
        List<CreativeTabsScreenPage> pages = scr.getPages();
        CreativeModeTab tab = this.tabs.get(ind);
        for (CreativeTabsScreenPage e : pages) {
            if (!e.getVisibleTabs().contains(tab)) continue;
            screen.setCurrentPage(e);
            scr.callSelectTab(tab);
            return true;
        }
        return true;
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pTick) {
        this.renderBg(g, pTick, mx, my);
        super.m_88315_(g, mx, my, pTick);
        g.m_280168_().m_85836_();
        g.m_280168_().m_85837_((double)this.leftPos, (double)this.topPos, 0.0);
        this.hovered = null;
        for (String c : this.slots) {
            this.renderSlotComp(g, c, mx, my);
        }
        this.renderLabels(g, mx, my);
        if (this.hovered != null) {
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
            this.renderTooltip(g, this.f_96547_, this.hovered, mx, my);
            g.m_280168_().m_85849_();
        }
        g.m_280168_().m_85849_();
    }

    private void renderSlotComp(GuiGraphics pose, String name, int mx, int my) {
        MenuLayoutConfig.Rect comp = this.manager.getComp(name);
        for (int i = 0; i < comp.rx; ++i) {
            for (int j = 0; j < comp.ry; ++j) {
                int sx = comp.x + comp.w * i;
                int sy = comp.y + comp.h * j;
                CreativeModeTab stack = this.getStack(name, i, j);
                if (stack == null) continue;
                this.renderSlot(pose, sx, sy, stack.m_40787_());
                if (!this.isHovering(name, i, j, mx, my)) continue;
                AbstractContainerScreen.m_280359_((GuiGraphics)pose, (int)sx, (int)sy, (int)-2130706433);
                this.hovered = stack;
            }
        }
    }

    private void renderSlot(GuiGraphics g, int x, int y, ItemStack stack) {
        String s = null;
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91074_ != null);
        g.m_280256_(stack, x, y, x + y * this.imageWidth);
        g.m_280302_(this.f_96547_, stack, x, y, s);
    }

    private void renderBg(GuiGraphics stack, float pt, int mx, int my) {
        MenuLayoutConfig menuLayoutConfig = this.manager;
        Objects.requireNonNull(menuLayoutConfig);
        MenuLayoutConfig.ScreenRenderer sr = menuLayoutConfig.new MenuLayoutConfig.ScreenRenderer(this, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        sr.start(stack);
    }

    private boolean isHovering(String slot, int i, int j, double mx, double my) {
        MenuLayoutConfig.Rect comp = this.manager.getComp(slot);
        return this.isHovering(comp.x + comp.w * i, comp.y + comp.h * j, 16, 16, mx, my);
    }

    private boolean isHovering(int x, int y, int w, int h, double mx, double my) {
        int i = this.leftPos;
        int j = this.topPos;
        return (mx -= (double)i) >= (double)(x - 1) && mx < (double)(x + w + 1) && (my -= (double)j) >= (double)(y - 1) && my < (double)(y + h + 1);
    }

    @Nullable
    protected SlotResult findSlot(double mx, double my) {
        for (String c : this.slots) {
            MenuLayoutConfig.Rect comp = this.manager.getComp(c);
            for (int i = 0; i < comp.rx; ++i) {
                for (int j = 0; j < comp.ry; ++j) {
                    if (!this.isHovering(c, i, j, mx, my)) continue;
                    return new SlotResult(c, i, j);
                }
            }
        }
        return null;
    }

    public record SlotResult(String name, int x, int y) {
    }
}

