/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jei_recipes;

import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.jei_recipes.BakeryJeiPlugin;
import com.renyigesai.bakeries.recipe.CoffeeRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DrinkRecipeCategory
implements IRecipeCategory<CoffeeRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("bakeries", "drink");
    public static final ResourceLocation TEXTURE = new ResourceLocation("bakeries", "textures/gui/jei_drink_gui.png");
    public final IDrawable back;
    public final IDrawable icon;

    public DrinkRecipeCategory(IGuiHelper helper) {
        this.back = helper.createDrawable(TEXTURE, 0, 0, 116, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BakeriesItems.DRINK_CUP.get()));
    }

    public RecipeType<CoffeeRecipe> getRecipeType() {
        return BakeryJeiPlugin.DRINK_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoffeeRecipe recipe, IFocusGroup iFocusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        int borderSlotSize = 18;
        int x = 2;
        int y = 2;
        for (int row = 0; row < 4; ++row) {
            if (row >= recipeIngredients.size()) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, x + row * borderSlotSize + 1, y).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(row)).m_43908_()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 1).addItemStack(recipe.m_8043_(null));
    }
}

