/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jei_recipes;

import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.jei_recipes.BakeryJeiPlugin;
import com.renyigesai.bakeries.recipe.BlenderRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BlenderCategory
implements IRecipeCategory<BlenderRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("bakeries", "blender");
    public static final ResourceLocation TEXTURE = new ResourceLocation("bakeries", "textures/gui/jei_blender_gui.png");
    public final IDrawable back;
    public final IDrawable icon;

    public BlenderCategory(IGuiHelper helper) {
        this.back = helper.createDrawable(TEXTURE, 0, 0, 125, 86);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BakeriesItems.BLENDER.get()));
    }

    public RecipeType<BlenderRecipe> getRecipeType() {
        return BakeryJeiPlugin.BLENDER_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.blender");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlenderRecipe recipe, IFocusGroup iFocusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        int borderSlotSize = 18;
        int x = 18;
        int y = 16;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputIndex = row * 3 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, x + column * borderSlotSize + 1, y + row * borderSlotSize + 1).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 90, 53).addItemStack(recipe.getContainer());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 17).addItemStack(recipe.m_8043_(null));
    }
}

