/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jade.provider;

import com.renyigesai.bakeries.block.baysalt_frame.BaysaltFrameBlockEntity;
import com.renyigesai.bakeries.jade.Identifiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.api.view.FluidView;
import snownee.jade.util.FluidTextHelper;

public enum BaysaltFrameComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Tag tag = accessor.getServerData().m_128423_("FluidTanks");
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)compoundTag);
            int fuel = fluid.getAmount();
            Component fluidComponent = fluid.getFluid().getFluidType().getDescription();
            IElementHelper helper = IElementHelper.get();
            if (!fluid.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.append((Component)IThemeHelper.get().info((Object)Component.m_237115_((String)"bakeries.fluid")));
                tooltip.append((Component)IThemeHelper.get().info((Object)fluidComponent));
            }
            FluidView fluidView = new FluidView(helper.fluid(JadeFluidObject.of((Fluid)fluid.getFluid())));
            fluidView.current = FluidTextHelper.getUnicodeMillibuckets((long)fluid.getAmount(), (boolean)true);
            fluidView.max = FluidTextHelper.getUnicodeMillibuckets((long)2000L, (boolean)true);
            fluidView.ratio = (float)((double)fluid.getAmount() / 2000.0);
            IProgressStyle progressStyle = helper.progressStyle().overlay(fluidView.overlay);
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.append(helper.progress(fluidView.ratio, (Component)fluid.getFluid().getFluidType().getDescription().m_6881_().m_130946_(": " + fuel + "mB"), progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
        }
        if (accessor.getServerData().m_128441_("progress") && accessor.getServerData().m_128441_("maxProgress")) {
            int progress = accessor.getServerData().m_128451_("progress");
            int maxProgress = accessor.getServerData().m_128451_("maxProgress");
            int p = progress * 100 / maxProgress;
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.append((Component)IThemeHelper.get().info((Object)Component.m_237115_((String)"bakeries.progress")));
            tooltip.append((Component)IThemeHelper.get().info((Object)p));
            tooltip.append((Component)IThemeHelper.get().info((Object)"%"));
        }
        if (accessor.getServerData().m_128441_("salts")) {
            int salts = accessor.getServerData().m_128451_("salts");
            int maxSalts = accessor.getServerData().m_128451_("max_salts");
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.append((Component)IThemeHelper.get().info((Object)Component.m_237115_((String)"bakeries.salts")));
            tooltip.append((Component)IThemeHelper.get().info((Object)salts));
            tooltip.append((Component)IThemeHelper.get().info((Object)"/"));
            tooltip.append((Component)IThemeHelper.get().info((Object)maxSalts));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BaysaltFrameBlockEntity brewingStand = (BaysaltFrameBlockEntity)accessor.getBlockEntity();
        CompoundTag compound = new CompoundTag();
        tag.m_128365_("FluidTanks", (Tag)brewingStand.getFluidTank().writeToNBT(compound));
        tag.m_128405_("salts", brewingStand.salts);
        tag.m_128405_("max_salts", brewingStand.max_salts);
        tag.m_128405_("progress", brewingStand.progress);
        tag.m_128405_("maxProgress", brewingStand.maxProgress);
    }

    public ResourceLocation getUid() {
        return Identifiers.BAYSALT_FRAME;
    }
}

