/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.renyigesai.bakeries.recipe.BreadKnifeRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class BreadKnifeItem
extends DiggerItem {
    public static final Set<ToolAction> KNIFE_ACTIONS = Set.of(ToolActions.SHEARS_CARVE);

    public BreadKnifeItem(float pAttackDamageModifier, float pAttackSpeedModifier, Tier pTier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, BlockTags.f_144280_, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack hand = pPlayer.m_21120_(pUsedHand);
        BlockHitResult raytraceresult = BreadKnifeItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!(raytraceresult instanceof BlockHitResult)) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        BlockHitResult ray = raytraceresult;
        Vec3 hitVec = ray.m_82450_();
        AABB bb = new AABB(hitVec, hitVec).m_82400_(1.0);
        ItemEntity resultItemEntity = null;
        for (ItemEntity e : pLevel.m_45976_(ItemEntity.class, bb)) {
            if (e.m_32055_().m_41613_() != 1) continue;
            resultItemEntity = e;
            break;
        }
        if (resultItemEntity == null) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        Optional<BreadKnifeRecipe> recipeOptional = this.getCurrentRecipe(pLevel, resultItemEntity.m_32055_());
        if (recipeOptional.isPresent()) {
            BreadKnifeRecipe recipe = recipeOptional.get();
            ItemStack resultItemStack = recipe.m_8043_(pLevel.m_9598_()).m_41777_();
            double x = resultItemEntity.m_20185_();
            double y = resultItemEntity.m_20186_();
            double z = resultItemEntity.m_20189_();
            hand.m_41622_(1, (LivingEntity)pPlayer, p_41300_ -> p_41300_.m_21190_(pUsedHand));
            ItemUtil.spawnItemEntity(pLevel, resultItemStack, x, y, z, new Vec3(0.0, 0.0, 0.0));
            pLevel.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, resultItemStack), x, y + 0.5, z, ((double)pLevel.f_46441_.m_188501_() - 0.5) * 0.08, ((double)pLevel.f_46441_.m_188501_() - 0.5) * 0.08, ((double)pLevel.f_46441_.m_188501_() - 0.5) * 0.08);
            pLevel.m_247517_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_12639_, SoundSource.BLOCKS);
            resultItemEntity.m_142687_(Entity.RemovalReason.KILLED);
        }
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19090_((Object)hand);
    }

    private Optional<BreadKnifeRecipe> getCurrentRecipe(Level level, ItemStack stack) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, stack);
        if (level == null) {
            return Optional.empty();
        }
        return level.m_7465_().m_44015_((RecipeType)BreadKnifeRecipe.Type.INSTANCE, (Container)inventory, level);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return KNIFE_ACTIONS.contains(toolAction);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.bakeries.bread_knife.tips").m_130940_(ChatFormatting.BLUE));
    }
}

