/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.data.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesGroup;
import com.renyigesai.bakeries.init.BakeriesItems;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BLanguageProvider
extends LanguageProvider {
    private final Map<String, String> enData = new TreeMap<String, String>();
    private final Map<String, String> cnData = new TreeMap<String, String>();
    private final PackOutput output;
    private final String locale;

    public BLanguageProvider(PackOutput output, String locale) {
        super(output, "bakeries", locale);
        this.output = output;
        this.locale = locale;
    }

    protected void addTranslations() {
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.DOUGH_CRAFTING_TABLE, "Dough Crafting Table", "\u9762\u80da\u5236\u4f5c\u53f0");
        this.add("container.dough_crafting_table", "Dough Crafting Table", "\u9762\u80da\u5236\u4f5c\u53f0");
        this.add("container.oven", "Oven", "\u70e4\u7089");
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.OVEN, "Oven", "\u70e4\u7089");
        this.addItem((Supplier<? extends Item>)BakeriesItems.YEAST_TANK, "Yeast Tank", "\u9175\u6bcd\u7f50");
        this.addItem((Supplier<? extends Item>)BakeriesItems.FERMENTATION_TANK, "Fermentation Tank", "\u53d1\u9175\u7f50");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BOTTLE_YEAST, "Bottle Yeast", "\u9175\u6bcd\u74f6");
        this.addItem((Supplier<? extends Item>)BakeriesItems.COARSE_SALT, "Coarse Salt", "\u7c97\u76d0");
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.GLASS_CABINET_DOOR, "Glass Cabinet Door", "\u73bb\u7483\u6a71\u67dc\u95e8");
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.SALT_ORE, "Salt Ore", "\u76d0\u77ff");
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.ROUND_BREAD, "Round Bread", "\u5706\u9762\u5305");
        this.addBlock((Supplier<? extends Block>)BakeriesBlocks.PINEAPPLE_BUN, "Pineapple Bun", "\u83e0\u841d\u5305");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BAGEL, "Bagel", "\u8d1d\u679c");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BAGUETTE, "Baguette", "\u6cd5\u68cd");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BROWN_SUGAR_ROLL, "Cinnamon Roll", "\u8089\u6842\u5377");
        this.addItem((Supplier<? extends Item>)BakeriesItems.COUNTRY_BREAD, "Country Bread", "\u4e61\u6751\u9762\u5305");
        this.addItem((Supplier<? extends Item>)BakeriesItems.CROISSANT, "Croissant", "\u53ef\u9882");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BAGEL_DOUGH, "Bagel Dough", "\u8d1d\u679c\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BAGUETTE_DOUGH, "Baguette Dough", "\u6cd5\u68cd\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BROWN_SUGAR_CUBE, "Brown Sugar Cube", "\u7ea2\u7cd6\u5757");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BUTTER_CUBE, "Butter Cube", "\u9ec4\u6cb9\u5757");
        this.addItem((Supplier<? extends Item>)BakeriesItems.BROWN_SUGAR_ROLL, "Cinnamon Roll Dough", "\u8089\u6842\u5377\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.COUNTRY_BREAD_DOUGH, "Country Bread Dough", "\u4e61\u6751\u9762\u5305\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.CROISSANT_DOUGH, "Croissant Dough", "\u53ef\u9882\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.FLOUR, "Flour", "\u9762\u7c89");
        this.addItem((Supplier<? extends Item>)BakeriesItems.WHOLE_WHEAT_FLOUR, "Whole Wheat Flour", "\u5168\u9ea6\u9762\u7c89");
        this.addItem((Supplier<? extends Item>)BakeriesItems.PINEAPPLE_BUN, "Pineapple Bun", "\u83e0\u841d\u5305");
        this.addItem((Supplier<? extends Item>)BakeriesItems.PINEAPPLE_BUN_DOUGH, "Pineapple Bun", "\u83e0\u841d\u5305\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.RAW_EGG_TART, "Raw Egg Tart", "\u751f\u86cb\u631e");
        this.addItem((Supplier<? extends Item>)BakeriesItems.RAW_PUMPKIN_PIE, "Pumpkin Pie", "\u5357\u74dc\u6d3e");
        this.addItem((Supplier<? extends Item>)BakeriesItems.RAW_TARE_CRUST, "Raw Tare Crust", "\u751f\u6d3e\u58f3");
        this.addItem((Supplier<? extends Item>)BakeriesItems.ROUND_BREAD_DOUGH, "Round Bread Dough", "\u5706\u9762\u5305\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.SALT, "Salt", "\u76d0");
        this.addItem((Supplier<? extends Item>)BakeriesItems.SALT_CROISSANT, "Salt Croissant", "\u76d0\u53ef\u9882");
        this.addItem((Supplier<? extends Item>)BakeriesItems.SALT_CROISSANT_DOUGH, "Salt Croissant Dough", "\u76d0\u53ef\u9882\u9762\u80da");
        this.addItem((Supplier<? extends Item>)BakeriesItems.ROUND_BREAD, "Round Bread", "\u5706\u9762\u5305");
        this.addItem((Supplier<? extends Item>)BakeriesItems.TART_SHELL, "Tart Shell", "\u86cb\u631e\u58f3");
        this.addTab((Supplier<CreativeModeTab>)BakeriesGroup.BAKERY_TAB, "Bakery", "\u70d8\u7119\u623f");
        this.addTab((Supplier<CreativeModeTab>)BakeriesGroup.BAKERY_SEMI_MANUFACTURED_PRODUCT_TAB, "Bakery Semi-Manufactured Product", "\u534a\u6210\u54c1");
    }

    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTranslations();
        Path path = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("bakeries").resolve("lang");
        if (this.locale.equals("en_us") && !this.enData.isEmpty()) {
            return this.save(this.enData, cache, path.resolve("en_us.json"));
        }
        if (this.locale.equals("zh_cn") && !this.cnData.isEmpty()) {
            return this.save(this.cnData, cache, path.resolve("zh_cn.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(Map<String, String> data, CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    private void addBlock(Supplier<? extends Block> key, String en_us, String zh_cn) {
        this.add(key.get().m_7705_(), en_us, zh_cn);
    }

    private void addItem(Supplier<? extends Item> key, String en_us, String zh_cn) {
        this.add(key.get().m_5524_(), en_us, zh_cn);
    }

    private void addDamageType(DamageType key, String en_us, String zh_cn) {
        this.add(key.f_268472_().m_7912_(), en_us, zh_cn);
    }

    private void addEntityType(Supplier<? extends EntityType<?>> key, String en_us, String zh_cn) {
        this.add(key.get().m_20675_(), en_us, zh_cn);
    }

    private void addEffect(Supplier<? extends MobEffect> key, String en_us, String zh_cn) {
        this.add(key.get().m_19481_(), en_us, zh_cn);
    }

    private void addBiome(ResourceKey<Biome> biome, String en_us, String zh_cn) {
        this.add("biome." + biome.m_135782_().m_214298_(), en_us, zh_cn);
    }

    private void addTab(Supplier<CreativeModeTab> tab, String en_us, String zh_cn) {
        this.add(tab.get().m_40786_().getString(), en_us, zh_cn);
    }

    private void addTooltips(String key, String en_us, String zh_cn) {
        this.add("tooltips.bakeries." + key, en_us, zh_cn);
    }

    private void addAttribute(Supplier<Attribute> attribute, String en_us, String zh_cn) {
        this.add("attribute." + attribute.get().m_22087_(), en_us, zh_cn);
    }

    private void addKeyMapping(String name, String en_us, String zh_cn) {
        this.add("key.bakeries." + name, en_us, zh_cn);
    }

    private void add(String key, String en_us, String zh_cn) {
        if (this.locale.equals("en_us") && !this.enData.containsKey(key)) {
            this.enData.put(key, en_us);
        } else if (this.locale.equals("zh_cn") && !this.cnData.containsKey(key)) {
            this.cnData.put(key, zh_cn);
        }
    }
}

