/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.data.provider;

import com.renyigesai.bakeries.api.block.PileBlock;
import com.renyigesai.bakeries.block.oven.OvenBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BBlockStateProvider
extends BlockStateProvider {
    public static final String CUTOUT = "cutout";

    public BBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "bakeries", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.BAGEL);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.BAGUETTE);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.BROWN_SUGAR_ROLL);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.CROISSANT);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.SALT_CROISSANT);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.PINEAPPLE_BUN);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.ROUND_BREAD);
        this.pileBlock((Supplier<? extends Block>)BakeriesBlocks.COUNTRY_BREAD);
        this.ovenBlock((Supplier<? extends Block>)BakeriesBlocks.OVEN);
    }

    public void ovenBlock(Supplier<? extends Block> block) {
        Iterator iterator = OvenBlock.LIT.m_6908_().iterator();
        while (iterator.hasNext()) {
            boolean lit = (Boolean)iterator.next();
            ModelBuilder modelFile = lit ? ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()) + "_fire", this.modLoc("custom/" + this.name(block.get())))).texture("0", this.modLoc("block/" + this.name(block.get()) + "_fire"))).texture("particle", this.modLoc("block/" + this.name(block.get()) + "_fire"))).renderType(CUTOUT) : ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()), this.modLoc("custom/" + this.name(block.get())))).texture("0", this.modLoc("block/" + this.name(block.get())))).texture("particle", this.modLoc("block/" + this.name(block.get())))).renderType(CUTOUT);
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                this.getVariantBuilder(block.get()).partialState().with((Property)OvenBlock.FACING, (Comparable)facing).with((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(lit)).modelForState().modelFile((ModelFile)modelFile).rotationY((int)facing.m_122435_()).addModel();
            }
        }
    }

    public void pileBlock(Supplier<? extends Block> block) {
        for (int pile : PileBlock.integerProperty.m_6908_()) {
            ModelBuilder modelFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()) + "_" + pile, this.modLoc("custom/" + this.name(block.get()) + "_" + pile))).texture("0", this.modLoc("block/" + this.name(block.get())))).texture("particle", this.modLoc("block/" + this.name(block.get())))).renderType(CUTOUT);
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                this.getVariantBuilder(block.get()).partialState().with((Property)PileBlock.f_54117_, (Comparable)facing).with((Property)PileBlock.integerProperty, (Comparable)Integer.valueOf(pile)).modelForState().modelFile((ModelFile)modelFile).rotationY((int)facing.m_122435_()).addModel();
            }
        }
    }

    private String name(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    private String name(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_();
    }
}

