/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.oven;

import com.renyigesai.bakeries.block.oven.OvenBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.inventory.oven.OvenMenu;
import com.renyigesai.bakeries.recipe.oven.OvenRecipe;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public final Component name = Component.m_237115_((String)"container.oven");
    private LazyOptional<IItemHandler> lazyItemHandlers = LazyOptional.empty();
    public final int[] cooking_times = new int[4];
    public final int[] max_cooking_times = new int[4];
    private final int[] min_temperatures = new int[4];
    private final int[] max_temperatures = new int[4];
    public int temperature;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> OvenBlockEntity.this.temperature;
                case 1 -> this.calculateProgress(0);
                case 2 -> this.calculateProgress(1);
                case 3 -> this.calculateProgress(2);
                case 4 -> this.calculateProgress(3);
                default -> 0;
            };
        }

        private int calculateProgress(int index) {
            if (OvenBlockEntity.this.max_cooking_times[index] == 0) {
                return 0;
            }
            return Math.min((int)((double)OvenBlockEntity.this.cooking_times[index] / (double)OvenBlockEntity.this.max_cooking_times[index] * 14.0), 14);
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                OvenBlockEntity.this.temperature = pValue;
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public OvenBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.OVEN_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    @NotNull
    protected Component m_6820_() {
        return this.name;
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new OvenMenu(pContainerId, pInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_), (Container)this, this.dataAccess);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128385_("cooking_times", this.cooking_times);
        pTag.m_128385_("max_cooking_times", this.max_cooking_times);
        pTag.m_128385_("min_temperatures", this.min_temperatures);
        pTag.m_128385_("max_temperatures", this.max_temperatures);
        pTag.m_128405_("temperature", this.temperature);
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        int[] aint;
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        if (pTag.m_128425_("CookingTimes", 11)) {
            aint = pTag.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cooking_times, 0, Math.min(this.max_cooking_times.length, aint.length));
        }
        if (pTag.m_128425_("MinTemperatures", 11)) {
            aint = pTag.m_128465_("MinTemperatures");
            System.arraycopy(aint, 0, this.min_temperatures, 0, Math.min(this.min_temperatures.length, aint.length));
        }
        if (pTag.m_128425_("MaxTemperatures", 11)) {
            aint = pTag.m_128465_("MaxTemperatures");
            System.arraycopy(aint, 0, this.max_temperatures, 0, Math.min(this.max_temperatures.length, aint.length));
        }
        this.temperature = pTag.m_128451_("temperature");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandlers.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlers = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlers.invalidate();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, OvenBlockEntity pOvenBlockEntity) {
        boolean flag = false;
        OvenBlockEntity.updateBlock(pOvenBlockEntity);
        OvenBlockEntity.setFire(pLevel, pPos, pState, pOvenBlockEntity);
        for (int i = 0; i < pOvenBlockEntity.itemHandler.getSlots(); ++i) {
            flag = true;
            OvenBlockEntity.recipeItem(pLevel, pPos, pState, i, pOvenBlockEntity);
        }
        if (flag) {
            OvenBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            OvenBlockEntity.updateBlock(pOvenBlockEntity);
        }
    }

    public static void setFire(Level world, BlockPos pos, BlockState state, OvenBlockEntity pOvenBlockEntity) {
        OvenBlockEntity.updateBlock(pOvenBlockEntity);
        boolean isLit = pOvenBlockEntity.cooking_times[0] > 0 || pOvenBlockEntity.cooking_times[1] > 0 || pOvenBlockEntity.cooking_times[2] > 0 || pOvenBlockEntity.cooking_times[3] > 0;
        world.m_7731_(pos, (BlockState)pOvenBlockEntity.m_58900_().m_61124_((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
        world.m_7260_(pos, state, state, 3);
        OvenBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
    }

    public int getTemperature(OvenBlockEntity ovenBlockEntity) {
        return ovenBlockEntity.temperature;
    }

    public void setTemperature(OvenBlockEntity ovenBlockEntity, int temperature) {
        OvenBlockEntity.updateBlock(ovenBlockEntity);
        ovenBlockEntity.temperature = Math.min(Math.max(temperature, 0), 500);
    }

    public void addTemperature(OvenBlockEntity ovenBlockEntity, int temperature) {
        OvenBlockEntity.updateBlock(ovenBlockEntity);
        ovenBlockEntity.temperature = Math.min(Math.max(this.getTemperature(ovenBlockEntity) + temperature, 0), 500);
    }

    public void subTemperature(OvenBlockEntity ovenBlockEntity, int temperature) {
        OvenBlockEntity.updateBlock(ovenBlockEntity);
        ovenBlockEntity.temperature = Math.min(Math.max(this.getTemperature(ovenBlockEntity) - temperature, 0), 500);
    }

    public static void updateBlock(OvenBlockEntity ovenBlockEntity) {
        Level world = ovenBlockEntity.m_58904_();
        BlockPos pos = ovenBlockEntity.m_58899_();
        BlockState state = world.m_8055_(pos);
        OvenBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        world.m_7260_(pos, state, state, 3);
    }

    private static void recipeItem(Level world, BlockPos pos, BlockState state, int slot, OvenBlockEntity ovenBlockEntity) {
        Optional<OvenRecipe> recipe = ovenBlockEntity.getCurrentRecipe(slot);
        int temperature = ovenBlockEntity.temperature;
        recipe.ifPresent(ovenRecipe -> {
            ovenBlockEntity.max_cooking_times[slot] = ovenRecipe.getTime();
            ovenBlockEntity.min_temperatures[slot] = Math.max(((OvenRecipe)recipe.get()).getMin_temperature(), 0);
            ovenBlockEntity.max_temperatures[slot] = Math.min(((OvenRecipe)recipe.get()).getMax_temperature(), 500);
        });
        if (ovenBlockEntity.hasRecipe(slot) && recipe.isPresent() && Math.max(ovenBlockEntity.min_temperatures[slot], 0) <= temperature) {
            if (!world.m_5776_()) {
                int n = slot;
                int n2 = ovenBlockEntity.cooking_times[n];
                ovenBlockEntity.cooking_times[n] = n2 + 1;
                int cookingTime = n2;
                int max_cooking_time = ovenBlockEntity.max_cooking_times[slot];
                int craft_temperature = Math.min(ovenBlockEntity.max_temperatures[slot], 500);
                if (cookingTime >= max_cooking_time) {
                    if (temperature <= craft_temperature) {
                        boolean perfect = true;
                        if (!recipe.get().isPresentPerfect() || temperature != recipe.get().getPerfect_temperature()) {
                            perfect = false;
                        }
                        ovenBlockEntity.craftItem(ovenBlockEntity, slot, perfect);
                    } else {
                        ovenBlockEntity.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)Items.f_42414_, 1));
                    }
                    world.m_7260_(pos, state, state, 3);
                    world.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    OvenBlockEntity.resetProgress(ovenBlockEntity, slot);
                }
            }
        } else if (!world.m_5776_()) {
            world.m_7260_(pos, state, state, 3);
            OvenBlockEntity.resetProgress(ovenBlockEntity, slot);
        }
    }

    private static void resetProgress(OvenBlockEntity ovenBlockEntity, int slot) {
        ovenBlockEntity.max_cooking_times[slot] = 0;
        ovenBlockEntity.cooking_times[slot] = 0;
        ovenBlockEntity.min_temperatures[slot] = 0;
        ovenBlockEntity.max_temperatures[slot] = 0;
    }

    private void craftItem(OvenBlockEntity ovenBlockEntity, int slot, boolean perfect) {
        OvenBlockEntity.updateBlock(ovenBlockEntity);
        Optional<OvenRecipe> recipe = this.getCurrentRecipe(slot);
        if (recipe.isPresent()) {
            ItemStack result = recipe.get().m_8043_(null);
            ItemStack takeItem = new ItemStack((ItemLike)result.m_41720_(), result.m_41613_());
            if (perfect) {
                takeItem.m_41784_().m_128379_("perfect", true);
            }
            this.itemHandler.setStackInSlot(slot, takeItem);
            OvenBlockEntity.updateBlock(ovenBlockEntity);
        }
    }

    private boolean hasRecipe(int slot) {
        Optional<OvenRecipe> recipe = this.getCurrentRecipe(slot);
        return recipe.isPresent() && ((Ingredient)recipe.get().m_7527_().get(0)).test(this.itemHandler.getStackInSlot(slot));
    }

    public Optional<OvenRecipe> getCurrentRecipe(int slot) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)OvenRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{this.itemHandler.getStackInSlot(slot)}), this.f_58857_);
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    @NotNull
    public ItemStack m_7407_(int pSlot, int pAmount) {
        return OvenBlockEntity.removeItem(this.itemHandler, pSlot, pAmount);
    }

    public static ItemStack removeItem(ItemStackHandler itemHandler, int pIndex, int pAmount) {
        return pIndex >= 0 && pIndex < itemHandler.getSlots() && !itemHandler.getStackInSlot(pIndex).m_41619_() && pAmount > 0 ? itemHandler.getStackInSlot(pIndex).m_41620_(pAmount) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int pSlot) {
        return OvenBlockEntity.takeItem(this.itemHandler, pSlot);
    }

    public static ItemStack takeItem(ItemStackHandler itemHandler, int pSlot) {
        return pSlot >= 0 && pSlot < itemHandler.getSlots() ? itemHandler.insertItem(pSlot, ItemStack.f_41583_, false) : ItemStack.f_41583_;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.itemHandler.insertItem(pSlot, pStack, false);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pSlot == 0 && !flag) {
            this.m_6596_();
        }
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int @NotNull [] m_7071_(@NotNull Direction pSide) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int pIndex, @NotNull ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public boolean m_7013_(int pIndex, @NotNull ItemStack pStack) {
        return this.itemHandler.getStackInSlot(pIndex).m_41619_();
    }
}

