/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.moka_pot;

import com.renyigesai.bakeries.block.moka_pot.MokaPotBlockEntity;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MokaPotBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = MokaPotBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.5, (double)10.0);

    public MokaPotBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : MokaPotBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BakeriesBlocks.MOKA_POT_ENTITY.get()), MokaPotBlockEntity::craftTick);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        ItemStack handStack = pPlayer.m_21120_(pHand);
        if (blockEntity instanceof MokaPotBlockEntity) {
            MokaPotBlockEntity mokaPotBlockEntity = (MokaPotBlockEntity)blockEntity;
            if (!handStack.m_41619_()) {
                if (mokaPotBlockEntity.isInventoryFull() && handStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:coffee_grounds")))) {
                    mokaPotBlockEntity.addGroundCoffee(handStack.m_41777_().m_41620_(1));
                    handStack.m_41774_(1);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12591_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                pLevel.m_7471_(pPos, false);
                ItemUtil.givePlayerItem(pPlayer, new ItemStack((ItemLike)this.getMokaPotItem(mokaPotBlockEntity).m_41720_()));
                pLevel.m_247517_(null, pPos, SoundEvents.f_12016_, SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private ItemStack getMokaPotItem(MokaPotBlockEntity mokaPotBlockEntity) {
        if (mokaPotBlockEntity.getFill()) {
            return new ItemStack((ItemLike)BakeriesItems.MOKA_POT_FILL.get());
        }
        return new ItemStack((ItemLike)BakeriesItems.MOKA_POT.get());
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        MokaPotBlockEntity mokaPotBlockEntity;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MokaPotBlockEntity && (mokaPotBlockEntity = (MokaPotBlockEntity)blockEntity).getCookingTotalTime() > 0) {
            double x = (double)pPos.m_123341_() + 0.5;
            double y = (double)pPos.m_123342_() + 0.5;
            double z = (double)pPos.m_123343_() + 0.5;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.01, 0.0);
        }
        super.m_214162_(pState, pLevel, pPos, pRandom);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MokaPotBlockEntity(pPos, pState);
    }
}

