/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.glass_drink_cup;

import com.renyigesai.bakeries.block.glass_drink_cup.GlassDrinkCupBlockEntity;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesSounds;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GlassDrinkCupBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = GlassDrinkCupBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.5, (double)10.0);

    public GlassDrinkCupBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GlassDrinkCupBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (blockEntity instanceof GlassDrinkCupBlockEntity) {
            GlassDrinkCupBlockEntity glassDrinkCupBlockEntity = (GlassDrinkCupBlockEntity)blockEntity;
            if (!stack.m_41619_() && glassDrinkCupBlockEntity.isInventoryFull()) {
                glassDrinkCupBlockEntity.addItem(stack.m_41777_().m_41620_(1), player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_247517_(null, pos, this.getSound(stack), SoundSource.BLOCKS);
                }
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            ItemStack craftItem = glassDrinkCupBlockEntity.inventory.getStackInSlot(4);
            if (!craftItem.m_41619_()) {
                this.spawnOrSetBlock(craftItem, level, pos);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_247517_(null, pos, (SoundEvent)BakeriesSounds.INSERT_STRAW.get(), SoundSource.BLOCKS);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, level, pos, player, hand, pHit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof GlassDrinkCupBlockEntity) {
                GlassDrinkCupBlockEntity glassDrinkCupBlockEntity = (GlassDrinkCupBlockEntity)blockEntity;
                glassDrinkCupBlockEntity.drops(glassDrinkCupBlockEntity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void spawnOrSetBlock(ItemStack stack, Level level, BlockPos pos) {
        Item item;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlassDrinkCupBlockEntity) {
            GlassDrinkCupBlockEntity glassDrinkCupBlockEntity = (GlassDrinkCupBlockEntity)blockEntity;
            glassDrinkCupBlockEntity.removeItems();
        }
        if ((item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50332_)) {
                level.m_7731_(pos, blockItem.m_40614_().m_49966_(), 3);
                return;
            }
        }
        ItemUtil.spawnItemEntity(level, stack, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, new Vec3(0.0, 0.0, 0.0));
        level.m_7471_(pos, false);
    }

    public SoundEvent getSound(ItemStack stack) {
        if (stack.m_41720_() instanceof BlockItem) {
            return (SoundEvent)BakeriesSounds.PUT_ON_ICE.get();
        }
        return SoundEvents.f_11769_;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : GlassDrinkCupBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BakeriesBlocks.DRINK_CUP_ENTITY.get()), GlassDrinkCupBlockEntity::tick);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }
}

