/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.blender;

import com.renyigesai.bakeries.api.block.WrappedHandler;
import com.renyigesai.bakeries.block.blender.BlenderBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.inventory.blender.BlenderMenu;
import com.renyigesai.bakeries.recipe.BlenderRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlenderBlockEntity
extends BaseContainerBlockEntity {
    private static final int CONTAINER_SLOT = 9;
    private static final int OUTPUT_SLOT = 10;
    private static final int[] SLOTS_FOR_DOWN = new int[]{10};
    protected final ItemStackHandler inventory = new ItemStackHandler(11);
    protected final ItemStackHandler filtrationinventory = new ItemStackHandler(10){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            super.setStackInSlot(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.inventory, i -> this.getIntList((int)i, SLOTS_FOR_DOWN), (i, s) -> false)));
    public int cookingTotalTime;
    public int filtrationIndex;

    public BlenderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BakeriesBlocks.BLENDER_ENTITY.get(), pos, state);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getFiltrationinventory() {
        return this.filtrationinventory;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.blender");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory playerInventory) {
        return new BlenderMenu(containerId, playerInventory, this);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean getIntList(int i, int[] intList) {
        for (int j = 0; j < intList.length; ++j) {
            if (intList[j] != i) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        return stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41620_(amount);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        for (int i = 0; i < this.filtrationinventory.getSlots(); ++i) {
            ItemStack filtrationStack = this.filtrationinventory.getStackInSlot(i);
            if (!stack.m_150930_(filtrationStack.m_41720_()) || !this.inventory.getStackInSlot(i).m_41619_()) continue;
            ItemStack singleStack = stack.m_41777_();
            stack.m_41774_(1);
            singleStack.m_41764_(1);
            this.inventory.setStackInSlot(i, singleStack);
            break;
        }
        this.m_6596_();
    }

    public void setFiltrationIndex(int filtrationIndex) {
        this.filtrationIndex = filtrationIndex;
    }

    public int getFiltrationIndex() {
        return this.filtrationIndex;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("FiltrationInventory")) {
            this.filtrationinventory.deserializeNBT(tag.m_128469_("FiltrationInventory"));
        }
        this.cookingTotalTime = tag.m_128451_("CookingTotalTime");
        this.filtrationIndex = tag.m_128451_("FiltrationIndex");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("FiltrationInventory", (Tag)this.filtrationinventory.serializeNBT());
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        tag.m_128405_("FiltrationIndex", this.filtrationIndex);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void drops(BlenderBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots());
        for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    private Optional<BlenderRecipe> getCurrentRecipe() {
        int i;
        SimpleContainer inventory = new SimpleContainer(10);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        for (i = 0; i < inputs.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)BlenderRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public static void craftTick(Level level, BlockPos pos, BlockState state, BlenderBlockEntity blockEntity) {
        blockEntity.craftItem();
        boolean temp = blockEntity.cookingTotalTime > 0;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlenderBlock.POWERED, (Comparable)Boolean.valueOf(temp)), 3);
        BlenderBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        if (!level.f_46443_) {
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void craftItem() {
        ItemStack outputStack;
        Optional<BlenderRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            this.cookingTotalTime = 0;
            return;
        }
        BlenderRecipe recipe = recipeOptional.get();
        ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
        if (!this.canCraft(resultItem, outputStack = this.inventory.getStackInSlot(10)) || !this.isContainer()) {
            this.cookingTotalTime = 0;
            return;
        }
        ArrayList<Ingredient> ingredientsToConsume = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
        ArrayList<Integer> slotsToConsume = new ArrayList<Integer>();
        block0: for (Ingredient ingredient : ingredientsToConsume) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_() || !ingredient.test(stack) || slotsToConsume.contains(i)) continue;
                slotsToConsume.add(i);
                continue block0;
            }
            this.cookingTotalTime = 0;
            return;
        }
        if (this.cookingTotalTime < 100) {
            ++this.cookingTotalTime;
            this.spawnParticle();
        } else {
            Iterator iterator = slotsToConsume.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_150930_(Items.f_42447_)) continue;
                if (stack.hasCraftingRemainingItem()) {
                    this.ejectIngredientRemainder(stack.getCraftingRemainingItem());
                }
                this.inventory.extractItem(slot, 1, false);
            }
            if (!recipe.getContainer().m_41619_()) {
                this.inventory.extractItem(9, 1, false);
            }
            if (outputStack.m_41619_()) {
                this.inventory.setStackInSlot(10, resultItem);
            } else {
                outputStack.m_41769_(resultItem.m_41613_());
            }
            this.cookingTotalTime = 0;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        BlockPos pos = this.m_58899_();
        Level level = this.f_58857_;
        Direction facing = ((Direction)level.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
        double x = (double)pos.m_123341_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        double newX = x + (double)facing.m_122429_() * 1.0;
        double newZ = z + (double)facing.m_122431_() * 1.0;
        ItemUtil.spawnItemEntity(this.f_58857_, remainderStack, newX, pos.m_123342_(), newZ, new Vec3(0.0, 0.0, 0.0));
    }

    private boolean isContainer() {
        Optional<BlenderRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            BlenderRecipe recipe = recipeOptional.get();
            if (recipe.getContainer().m_150930_(this.inventory.getStackInSlot(9).m_41720_())) {
                return true;
            }
            return recipe.getContainer().m_41619_();
        }
        return false;
    }

    private boolean canCraft(ItemStack resultItem, ItemStack outputStack) {
        if (outputStack.m_41619_()) {
            return true;
        }
        return resultItem.m_150930_(outputStack.m_41720_()) && outputStack.m_41613_() != outputStack.m_41741_();
    }

    private void spawnParticle() {
        BlockPos pos = this.m_58899_();
        Level pLevel = this.f_58857_;
        if (pLevel instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stackInSlot = this.inventory.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                stacks.add(stackInSlot);
            }
            for (i = 0; i < stacks.size(); ++i) {
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)stacks.get(i)), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.075);
            }
        }
    }

    public boolean m_7013_(int pIndex, ItemStack stack) {
        for (int i = 0; i < this.filtrationinventory.getSlots(); ++i) {
            ItemStack filtrationStack = this.filtrationinventory.getStackInSlot(i);
            if (!stack.m_150930_(filtrationStack.m_41720_()) || !this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side) && (side == Direction.UP || side == Direction.DOWN)) {
                return this.directionWrappedHandlerMap.get(side).cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

