/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.baysalt_frame;

import com.renyigesai.bakeries.block.baysalt_frame.BaysaltFrameBlock;
import com.renyigesai.bakeries.fluid.BakeriesFluids;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.network.FluidSyncS2CPacket;
import com.renyigesai.bakeries.network.Messages;
import com.renyigesai.bakeries.util.FluidUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class BaysaltFrameBlockEntity
extends BlockEntity {
    private final FluidTank fluidTank = new FluidTank(2000, fs -> fs.getFluid() == BakeriesFluids.FLOWING_SALT_WATER.get()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BaysaltFrameBlockEntity.this.m_6596_();
            if (!BaysaltFrameBlockEntity.this.f_58857_.m_5776_()) {
                Messages.sendToClients(new FluidSyncS2CPacket(this.fluid, BaysaltFrameBlockEntity.this.f_58858_));
            }
        }
    };
    public int salts = 0;
    public final int max_salts = 100;
    public int progress = 0;
    public final int maxProgress = 200;

    public BaysaltFrameBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.BAYSALT_FRAME_ENTITY.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("maxProgress", this.maxProgress);
        pTag.m_128405_("salts", this.salts);
        pTag.m_128405_("max_salts", this.max_salts);
        pTag.m_128365_("FluidTanks", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        Tag tag = pTag.m_128423_("FluidTanks");
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(compoundTag);
        }
        this.progress = pTag.m_128451_("progress");
        this.salts = pTag.m_128451_("salts");
    }

    public void setFluid(FluidStack stack) {
        this.fluidTank.setFluid(stack);
    }

    public void addFluid(Player player, BlockPos pos, FluidTank tank, SoundEvent sound, ItemStack useItem, ItemStack outItem, FluidStack fluid) {
        FluidUtil.addFluid(player, pos, tank, sound, useItem, outItem, fluid);
    }

    public void getFluid(Player player, BlockPos pos, FluidTank tank, SoundEvent sound, ItemStack useItem, ItemStack outItem, FluidStack fluid) {
        FluidUtil.getFluid(player, pos, tank, sound, useItem, outItem, fluid);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, BaysaltFrameBlockEntity pBaysaltFrameBlockEntity) {
        boolean flag = false;
        BaysaltFrameBlockEntity.updateBlock(pBaysaltFrameBlockEntity);
        if (pBaysaltFrameBlockEntity.getFluidTank().getFluidAmount() > 0) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BaysaltFrameBlock.LIT, (Comparable)Integer.valueOf(1)), 3);
        } else if (pBaysaltFrameBlockEntity.salts >= 10) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BaysaltFrameBlock.LIT, (Comparable)Integer.valueOf(2)), 3);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BaysaltFrameBlock.LIT, (Comparable)Integer.valueOf(0)), 3);
        }
        if (pBaysaltFrameBlockEntity.getFluidTank().isFluidValid(new FluidStack((Fluid)BakeriesFluids.FLOWING_SALT_WATER.get(), 1000)) && !pLevel.m_6106_().m_6533_() && !pLevel.m_6106_().m_6534_() && pLevel.m_46861_(pPos) && pLevel.m_46461_()) {
            if (!pLevel.m_5776_()) {
                if (pBaysaltFrameBlockEntity.salts < pBaysaltFrameBlockEntity.max_salts && pBaysaltFrameBlockEntity.getFluidTank().drain(new FluidStack((Fluid)BakeriesFluids.FLOWING_SALT_WATER.get(), 10), IFluidHandler.FluidAction.SIMULATE).getAmount() >= 10) {
                    ++pBaysaltFrameBlockEntity.progress;
                }
                if (pBaysaltFrameBlockEntity.progress >= pBaysaltFrameBlockEntity.maxProgress) {
                    ++pBaysaltFrameBlockEntity.salts;
                    pBaysaltFrameBlockEntity.getFluidTank().drain(new FluidStack((Fluid)BakeriesFluids.FLOWING_SALT_WATER.get(), 10), IFluidHandler.FluidAction.EXECUTE);
                    pLevel.m_7260_(pPos, pState, pState, 3);
                    pBaysaltFrameBlockEntity.progress = 0;
                }
            }
            flag = true;
        } else if (!pLevel.m_5776_()) {
            pLevel.m_7260_(pPos, pState, pState, 3);
            pBaysaltFrameBlockEntity.progress = 0;
        }
        if (flag) {
            BaysaltFrameBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void updateBlock(BaysaltFrameBlockEntity pBaysaltFrameBlockEntity) {
        Level world = pBaysaltFrameBlockEntity.m_58904_();
        BlockPos pos = pBaysaltFrameBlockEntity.m_58899_();
        BlockState state = world.m_8055_(pos);
        BaysaltFrameBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        world.m_7260_(pos, state, state, 3);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

