/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.api.block.properties.ModIntegerProperty;
import com.renyigesai.bakeries.block.IKnifeCutBlock;
import com.renyigesai.bakeries.init.BakeriesItemTag;
import com.renyigesai.bakeries.util.ItemUtil;
import com.renyigesai.bakeries.util.Shortcuts;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ToastBlock
extends HorizontalDirectionalBlock
implements IKnifeCutBlock {
    public static final ModIntegerProperty PILE = ModIntegerProperty.create("pile", 1, 2);
    public static final IntegerProperty SLICE = IntegerProperty.m_61631_((String)"slice", (int)1, (int)4);
    protected static final VoxelShape X_BOX = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)5.0, (double)12.0);
    protected static final VoxelShape Z_BOX = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)5.0, (double)10.0);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    public final Supplier<Item> sliceItem;

    public ToastBlock(BlockBehaviour.Properties pProperties, Supplier<Item> sliceItem) {
        super(pProperties);
        this.sliceItem = sliceItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PILE, (Comparable)Integer.valueOf(1))).m_61124_((Property)SLICE, (Comparable)Integer.valueOf(4))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack hand = pPlayer.m_21120_(pHand);
        int pile = (Integer)pState.m_61143_((Property)PILE);
        if (this.isKnifeItem(hand) && pile == 1) {
            return this.cut(pLevel, pPos, pState, pPlayer);
        }
        if (hand.m_150930_(this.m_5456_()) && pile < 2) {
            if (!pPlayer.m_150110_().f_35937_) {
                hand.m_41774_(1);
            }
            return this.pileUp(pLevel, pPos, pState, pPlayer);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public ItemStack getSliceItem() {
        return new ItemStack((ItemLike)this.sliceItem.get());
    }

    protected InteractionResult cut(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int slice = (Integer)state.m_61143_((Property)SLICE);
        if (slice > 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SLICE, (Comparable)Integer.valueOf(slice - 1)), 6);
        } else {
            level.m_7471_(pos, false);
        }
        ItemUtil.spawnItemEntity(level, this.getSliceItem(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new Vec3(0.0, 0.0, 0.0));
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult pileUp(Level level, BlockPos pos, BlockState state, Player playerIn) {
        Shortcuts.setBlock(level, pos, state, PILE, 1, true);
        level.m_5594_(null, pos, SoundEvents.f_12591_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        int pile = (Integer)state.m_61143_((Property)PILE);
        if (pile > 1) {
            return SHAPE;
        }
        return direction.m_122434_() == Direction.Axis.X ? X_BOX : Z_BOX;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PILE, SLICE});
    }

    public int m_6782_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return ToastBlock.getOutputSignal((Integer)pState.m_61143_((Property)SLICE));
    }

    public static int getOutputSignal(int pEaten) {
        return (-4 - pEaten) * 2;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    @Override
    public boolean isKnifeItem(ItemStack itemStack) {
        return itemStack.m_204117_(BakeriesItemTag.BREAD_KNIFE) || itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tools/knives")));
    }
}

