/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.api.block.properties.ModIntegerProperty;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.util.ItemUtil;
import com.renyigesai.bakeries.util.Shortcuts;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MouldToastBlock
extends HorizontalDirectionalBlock {
    public final Supplier<Item> demouldItem;
    public static final ModIntegerProperty PILE = ModIntegerProperty.create("pile", 1, 2);
    public static final BooleanProperty FILL = BooleanProperty.m_61465_((String)"fill");
    protected static final VoxelShape X_BOX = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)5.0, (double)12.0);
    protected static final VoxelShape Z_BOX = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)5.0, (double)10.0);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);

    public MouldToastBlock(BlockBehaviour.Properties pProperties, Supplier<Item> demouldItem) {
        super(pProperties);
        this.demouldItem = demouldItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PILE, (Comparable)Integer.valueOf(1))).m_61124_((Property)FILL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack hand = pPlayer.m_21120_(pHand);
        if (!pLevel.f_46443_) {
            if (!hand.m_150930_(this.m_5456_())) {
                return this.take(pLevel, pPos, pState, pPlayer);
            }
            return this.pileUp(pLevel, pPos, pState, pPlayer, pHand);
        }
        if (!hand.m_150930_(this.m_5456_())) {
            return this.take(pLevel, pPos, pState, pPlayer);
        }
        return this.pileUp(pLevel, pPos, pState, pPlayer, pHand);
    }

    protected InteractionResult pileUp(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        int pile = (Integer)state.m_61143_((Property)PILE);
        if (pile < 2) {
            if (!player.m_150110_().f_35937_) {
                handStack.m_41774_(1);
            }
            Shortcuts.setBlock(level, pos, state, PILE, 1, true);
            level.m_5594_(null, pos, SoundEvents.f_12065_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult take(Level level, BlockPos pos, BlockState state, Player player) {
        int pile = (Integer)state.m_61143_((Property)PILE);
        if (pile == 1) {
            ItemUtil.givePlayerItem(player, new ItemStack((ItemLike)this.demouldItem.get()));
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            BlockState bBlockState = (BlockState)((Block)BakeriesBlocks.MOULD.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing);
            level.m_46597_(pos, bBlockState);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        int pile = (Integer)state.m_61143_((Property)PILE);
        if (pile > 1) {
            return SHAPE;
        }
        return direction.m_122434_() == Direction.Axis.X ? X_BOX : Z_BOX;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PILE, FILL});
    }
}

