/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.block.FermentationBarrelBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.inventory.fermentation_barrel.FermentationBarrelMenu;
import com.renyigesai.bakeries.recipe.FermentationRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelBlockEntity
extends BaseContainerBlockEntity {
    protected final ItemStackHandler inventory = new ItemStackHandler(9){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot == 8) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    };
    private int cookingTotalTime;
    private static final int STORAGE_CONTAINER_SLOT = 6;
    private static final int STORAGE_SLOT = 7;
    private static final int OUTPUT_SLOT = 8;

    public FermentationBarrelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.FERMENTATION_BARREL_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.cookingTotalTime = tag.m_128451_("CookingTotalTime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.fermentation_barrel");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory playerInventory) {
        return new FermentationBarrelMenu(containerId, playerInventory, this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public void drops(FermentationBarrelBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(7);
        for (int i = 0; i < 6; ++i) {
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        inventory.m_6836_(6, blockEntity.inventory.getStackInSlot(8));
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    private Optional<FermentationRecipe> getCurrentRecipe() {
        int i;
        SimpleContainer inventory = new SimpleContainer(6);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (i = 0; i < 6; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        for (i = 0; i < inputs.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)FermentationRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FermentationBarrelBlockEntity blockEntity) {
        blockEntity.craftItem();
        blockEntity.takeTick();
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FermentationBarrelBlock.FILL, (Comparable)Boolean.valueOf(FermentationBarrelBlockEntity.isFill(blockEntity))), 3);
        FermentationBarrelBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        if (!level.f_46443_) {
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void craftItem() {
        Optional<FermentationRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            this.cookingTotalTime = 0;
            if (this.inventory.getStackInSlot(7).m_41619_()) {
                this.inventory.setStackInSlot(6, ItemStack.f_41583_);
            }
            return;
        }
        FermentationRecipe recipe = recipeOptional.get();
        ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
        ItemStack outputStack = this.inventory.getStackInSlot(7);
        if (!recipe.getContainer().m_41619_()) {
            this.inventory.setStackInSlot(6, recipe.getContainer());
        }
        for (int i = 0; i < 6 && this.inventory.getStackInSlot(i).m_41619_() && this.inventory.getStackInSlot(7).m_41619_(); ++i) {
            this.inventory.setStackInSlot(6, ItemStack.f_41583_);
        }
        if (!this.canCraft(resultItem, outputStack)) {
            this.cookingTotalTime = 0;
            return;
        }
        ArrayList<Ingredient> ingredientsToConsume = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
        ArrayList<Integer> slotsToConsume = new ArrayList<Integer>();
        block1: for (Ingredient ingredient : ingredientsToConsume) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_() || !ingredient.test(stack) || slotsToConsume.contains(i)) continue;
                slotsToConsume.add(i);
                continue block1;
            }
            this.cookingTotalTime = 0;
            return;
        }
        if (this.cookingTotalTime < 3600) {
            ++this.cookingTotalTime;
        } else {
            Iterator iterator = slotsToConsume.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_150930_(Items.f_42447_)) continue;
                if (stack.hasCraftingRemainingItem()) {
                    this.ejectIngredientRemainder(stack.getCraftingRemainingItem());
                }
                this.inventory.extractItem(slot, 1, false);
            }
            if (outputStack.m_41619_()) {
                this.inventory.setStackInSlot(7, resultItem);
            } else {
                outputStack.m_41769_(resultItem.m_41613_());
            }
            this.cookingTotalTime = 0;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void takeTick() {
        if (!this.inventory.getStackInSlot(7).m_41619_()) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(6);
            ItemStack stackInOutputSlot = this.inventory.getStackInSlot(8);
            if (stackInOutputSlot.m_150930_(stackInSlot.m_41720_())) {
                ItemStack copy = this.inventory.getStackInSlot(7).m_41777_();
                copy.m_41764_(1);
                this.inventory.setStackInSlot(8, copy);
                this.inventory.extractItem(7, 1, false);
            }
        }
    }

    public static boolean isFill(FermentationBarrelBlockEntity blockEntity) {
        return !blockEntity.inventory.getStackInSlot(7).m_41619_() || !blockEntity.inventory.getStackInSlot(8).m_41619_();
    }

    private boolean canCraft(ItemStack resultItem, ItemStack outputStack) {
        if (outputStack.m_41619_()) {
            return true;
        }
        return resultItem.m_150930_(outputStack.m_41720_()) && outputStack.m_41613_() != outputStack.m_41741_();
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        BlockPos pos = this.m_58899_();
        Level level = this.f_58857_;
        Direction facing = ((Direction)level.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
        double x = (double)pos.m_123341_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        double newX = x + (double)facing.m_122429_() * 1.0;
        double newZ = z + (double)facing.m_122431_() * 1.0;
        System.out.println(newX);
        System.out.println(newZ);
        ItemUtil.spawnItemEntity(this.f_58857_, remainderStack, newX, pos.m_123342_(), newZ, new Vec3(0.0, 0.0, 0.0));
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.inventory.getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.inventory.extractItem(pSlot, pAmount, false);
    }

    public ItemStack m_8016_(int pSlot) {
        return null;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inventory.setStackInSlot(pSlot, pStack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

