/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.api;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectProperties {
    private final List<Pair<Supplier<MobEffectInstance>, Float>> effects;

    private EffectProperties(Builder builder) {
        this.effects = builder.effects;
    }

    public List<Pair<MobEffectInstance, Float>> getEffects() {
        return this.effects.stream().map(pair -> Pair.of((Object)(pair.getFirst() != null ? (MobEffectInstance)((Supplier)pair.getFirst()).get() : null), (Object)((Float)pair.getSecond()))).collect(Collectors.toList());
    }

    public static class Builder {
        private final List<Pair<Supplier<MobEffectInstance>, Float>> effects = Lists.newArrayList();

        public Builder effect(Supplier<MobEffectInstance> effectIn, float probability) {
            this.effects.add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(effectIn, (Object)Float.valueOf(probability)));
            return this;
        }

        @Deprecated
        public Builder effect(MobEffectInstance pEffect, float pProbability) {
            this.effects.add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(() -> pEffect, (Object)Float.valueOf(pProbability)));
            return this;
        }

        public EffectProperties build() {
            return new EffectProperties(this);
        }
    }
}

