/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAnimTriggerPacket
extends AbstractPacket {
    private final BlockPos blockPos;
    private final String controllerName;
    private final String animName;

    public BlockEntityAnimTriggerPacket(BlockPos blockPos, @Nullable String controllerName, String animName) {
        this.blockPos = blockPos;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_130070_(this.controllerName);
        buf.m_130070_(this.animName);
    }

    @Override
    public ResourceLocation getPacketID() {
        return AzureLibNetwork.BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static BlockEntityAnimTriggerPacket receive(FriendlyByteBuf buf) {
        return new BlockEntityAnimTriggerPacket(buf.m_130135_(), buf.m_130277_(), buf.m_130277_());
    }

    @Override
    public void handle() {
        BlockEntity blockEntity = ClientUtils.getLevel().m_7702_(this.blockPos);
        if (blockEntity instanceof GeoBlockEntity) {
            GeoBlockEntity getBlockEntity = (GeoBlockEntity)blockEntity;
            getBlockEntity.triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
        }
    }
}

