/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.recipe;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipeSerializer;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AutoMechanicTableRecipe
implements Recipe<SimpleContainer>,
Comparable<AutoMechanicTableRecipe> {
    public static final ResourceLocation ID = Automobility.rl("auto_mechanic_table");
    public static final RecipeType<AutoMechanicTableRecipe> TYPE = new RecipeType<AutoMechanicTableRecipe>(){};
    private final ResourceLocation id;
    protected final ResourceLocation category;
    protected final Set<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int sortNum;

    public AutoMechanicTableRecipe(ResourceLocation id, ResourceLocation category, Set<Ingredient> ingredients, ItemStack result, int sortNum) {
        this.id = id;
        this.category = category;
        this.ingredients = ingredients;
        this.result = result;
        this.sortNum = sortNum;
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    public boolean matches(SimpleContainer inv, Level lvl) {
        boolean[] result = new boolean[]{true};
        this.forMissingIngredients((Container)inv, ing -> {
            result[0] = false;
        });
        return result[0];
    }

    public ItemStack assemble(SimpleContainer inv, RegistryAccess var2) {
        return this.assemble(inv);
    }

    public ItemStack assemble(SimpleContainer inv) {
        block0: for (Ingredient ing : this.ingredients) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ing.test(stack)) continue;
                stack.m_41774_(1);
                continue block0;
            }
        }
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess var1) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return AutoMechanicTableRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public void forMissingIngredients(Container inv, Consumer<Ingredient> action) {
        ArrayList<ItemStack> invCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            invCopy.add(inv.m_8020_(i));
        }
        for (Ingredient ing : this.ingredients) {
            if (invCopy.stream().noneMatch(ing)) {
                action.accept(ing);
                continue;
            }
            invCopy.remove(invCopy.stream().filter(ing).collect(Collectors.toList()).get(0));
        }
    }

    @Override
    public int compareTo(@NotNull AutoMechanicTableRecipe o) {
        int diff = this.getCategory().compareTo(o.getCategory());
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(this.sortNum, o.sortNum);
        if (diff != 0) {
            return diff;
        }
        return this.m_6423_().compareTo(o.m_6423_());
    }
}

