/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

public final class Quat4f {
    public static Quat4f UNIT = new Quat4f();
    private static final float EPS = 1.0E-6f;
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    public Quat4f() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quat4f(Quat4f q) {
        this(q.x, q.y, q.z, q.w);
    }

    public Quat4f(double x, double y, double z, double w) {
        this((float)x, (float)y, (float)z, (float)w);
    }

    public Quat4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public float dot(Quat4f q) {
        return this.w * q.w + this.x * q.x + this.y * q.y + this.z * q.z;
    }

    public Quat4f negate() {
        return new Quat4f(-this.x, -this.y, -this.z, -this.w);
    }

    public float norm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quat4f normalize() {
        double n = 1.0 / Math.sqrt(this.norm());
        return new Quat4f((double)this.x * n, (double)this.y * n, (double)this.z * n, (double)this.w * n);
    }

    public Quat4f interpolate(Quat4f q2, float t) {
        double s1;
        double s0;
        if (this.x == q2.x && this.y == q2.y && this.z == q2.z && this.w == q2.w) {
            return this;
        }
        float dot = this.dot(q2);
        if ((double)dot < 0.0) {
            q2 = q2.negate();
            dot = -dot;
        }
        if (1.0f - dot > 1.0E-6f) {
            double theta = Math.acos(dot);
            double invSinTheta = Math.sin(theta);
            s0 = Math.sin((double)(1.0f - t) * theta) / invSinTheta;
            s1 = Math.sin((double)t * theta) / invSinTheta;
        } else {
            s0 = 1.0f - t;
            s1 = t;
        }
        return new Quat4f(s0 * (double)this.x + s1 * (double)q2.x, s0 * (double)this.y + s1 * (double)q2.y, s0 * (double)this.z + s1 * (double)q2.z, s0 * (double)this.w + s1 * (double)q2.w);
    }

    public Quat4f mul(Quat4f other) {
        return new Quat4f(this.x * other.w + this.y * other.z - this.z * other.y + this.w * other.x, -this.x * other.z + this.y * other.w + this.z * other.x + this.w * other.y, this.x * other.y - this.y * other.x + this.z * other.w + this.w * other.z, -this.x * other.x - this.y * other.y - this.z * other.z + this.w * other.w);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quat4f) {
            Quat4f other = (Quat4f)obj;
            return Float.compare(this.x, other.x) == 0 && Float.compare(this.y, other.y) == 0 && Float.compare(this.z, other.z) == 0 && Float.compare(this.w, other.w) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 31;
        hash = 31 * hash + Long.hashCode(Float.floatToIntBits(this.x));
        hash = 31 * hash + Long.hashCode(Float.floatToIntBits(this.y));
        hash = 31 * hash + Long.hashCode(Float.floatToIntBits(this.z));
        hash = 31 * hash + Long.hashCode(Float.floatToIntBits(this.w));
        return hash;
    }

    public String toString() {
        return "Quat4f{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + "}";
    }

    public static Quat4f fromAxisAngle(float x, float y, float z, float angle) {
        double sin = Math.sin(0.5 * (double)angle);
        return new Quat4f((double)x * sin, (double)y * sin, (double)z * sin, Math.cos(0.5 * (double)angle));
    }
}

